package cn.com.duiba.developer.center.api.domain.paramquery.authority;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 版本过期查询
 *
 * @author fja
 */
public class VersionExpiredQueryParam implements Serializable {

    private static final long serialVersionUID = 4455253341929270766L;

    /**
     * 查询开始时间
     */
    private Date startTime;

    /**
     * 查询结束时间
     */
    private Date endTime;

    /**
     * 1 版本 2 零售包
     */
    private List<Integer> attributeTypes;

    /**
     * 查询应用id集合
     */
    private List<Long> appIdList;


    public VersionExpiredQueryParam() {}


    public VersionExpiredQueryParam(Date startTime, Date endTime, List<Integer> attributeTypes, List<Long> appIdList) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.attributeTypes = attributeTypes;
        this.appIdList = appIdList;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public List<Integer> getAttributeTypes() {
        return attributeTypes;
    }

    public void setAttributeTypes(List<Integer> attributeTypes) {
        this.attributeTypes = attributeTypes;
    }

    public List<Long> getAppIdList() {
        return appIdList;
    }

    public void setAppIdList(List<Long> appIdList) {
        this.appIdList = appIdList;
    }
}
