package cn.com.duiba.developer.center.api.remoteservice.authority;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.authority.VersionAppDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.VersionDto;
import cn.com.duiba.developer.center.api.domain.enums.authority.VersionOptEnum;
import cn.com.duiba.developer.center.api.domain.param.authority.VersionBasicInfoDto;
import cn.com.duiba.developer.center.api.domain.param.authority.VersionDetailInfoDto;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.AddVersionParam;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.OpenParamParam;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionExpiredQueryParam;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionSaveParam;
import com.google.common.base.Optional;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVersionService {


    /**
     *@Desc 保存新版本
     *@params
     */
    void saveVersion(VersionSaveParam versionSaveParam) throws BizException;

    /**
     *@Desc 获取版本信息
     *@params
     */
    VersionDto getById(Long id) throws BizException;


    /**
     *@Desc 获取版本信息 包含具体的权益标签 以及权限
     *@params
     */
    VersionDetailInfoDto getVersionInfo(Long id) throws BizException;


    /**
     *@Desc 获取版本或者零售包的信息 只包含基础信息
     *@params 【type  1。版本  2 零售包】
     */
    List<VersionBasicInfoDto> versionList(Long type,String name,Integer pageNo,Integer pageSize) throws BizException;

    /**
     *@Desc 开启或者
     *@params 【id 版本id/零售包id openParamParam.status 1 开启 2 关闭】
     */
    void openVersion(OpenParamParam openParamParam) throws BizException;

    /**
     *@Desc 删除指定版本下的app
     *@params 【id  app版本记录的id 】
     */
    void deleteVerisonApp(Long id) throws BizException;

    /**
     *@Desc 给指定版本下添加app
     *@params addVersionParam
     */
    void addVerisonApp(AddVersionParam addVersionParam) throws BizException;

    /**
     *@Desc 给指定版本下app续费
     *@params  addVersionParam
     *@params  VersionOptEnum
     */
    void updateVerisonApp(AddVersionParam addVersionParam, VersionOptEnum versionOptEnum) throws BizException;

    /**
     *@Desc 批量获取版本
     *@params  versionIds
     */
    List<VersionDto>  listByVersionId(List<Long> versionIds) throws BizException;

    /**
     *@Desc 给指定版本下app续费
     *@params  type  1 版本  2 零售包
     *@params  name
     *@params  pageNo
     *@params  pageSize
     */
    Integer getBySaleTypeAndNameCount(Long type, String name, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 返回appid 对应的版本 如果版本过期了，optional值为空
     * @param appId
     * @return
     */
    Optional<VersionDto> getVersionDtoByAppId(Long appId)  throws BizException;

    List<VersionAppDto> getExpireAppIds();

    /**
     * 根据结束日期查询
     *
     * @param queryParam 查询条件
     * @return 结果
     */
    List<VersionAppDto> findVersionByEndTime(VersionExpiredQueryParam queryParam);

    /**
     * 删除单独售卖包版本
     * @param id
     * @return
     */
    int deleteResaleById(Long id) throws BizException;
}
