package cn.com.duiba.developer.center.api.domain.paramquery;

import cn.com.duiba.developer.center.api.domain.dto.saas.SaasPriceListDto;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;

import java.io.Serializable;

/**
 * Created by zyj on 2018/4/26.
 */
public class SaasPriceQueryParam implements Serializable {
    private static final long serialVersionUID = -5997411168682212705L;


    /**
     * 关联id
     */
    private Long funcRelId = SaasPriceListDto.DEFAULT_FUNC_REL_ID;
    /**
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤；
     */
    private SaasFuncTypeEnum saasFuncTypeEnum;
    /**
     * 功能子类型
     */
    private Integer saasFuncSubType = SaasPriceListDto.DEFAULT_FUNC_SUB_TYPE;

    public SaasPriceQueryParam(Long funcRelId, SaasFuncTypeEnum saasFuncTypeEnum, Integer saasFuncSubType) {
        this.funcRelId = funcRelId;
        this.saasFuncTypeEnum = saasFuncTypeEnum;
        this.saasFuncSubType = saasFuncSubType;
    }
    public SaasPriceQueryParam(){

    }

    public Long getFuncRelId() {
        return funcRelId;
    }

    public void setFuncRelId(Long funcRelId) {
        this.funcRelId = funcRelId;
    }

    public SaasFuncTypeEnum getSaasFuncTypeEnum() {
        return saasFuncTypeEnum;
    }

    public void setSaasFuncTypeEnum(SaasFuncTypeEnum saasFuncTypeEnum) {
        this.saasFuncTypeEnum = saasFuncTypeEnum;
    }

    public Integer getSaasFuncSubType() {
        return saasFuncSubType;
    }

    public void setSaasFuncSubType(Integer saasFuncSubType) {
        this.saasFuncSubType = saasFuncSubType;
    }
}
