package cn.com.duiba.developer.center.api.domain.dto.strategy;

import cn.com.duiba.developer.center.api.domain.constant.StrategyExperienceStatusEnum;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经验
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyExperienceDto implements Serializable {

    private static final long serialVersionUID = 8244496459233711665L;

    /**
     * ID
     */
    private Long id;

    /**
     * 类型
     * 从级联表中取
     */
    @NotNull(message = "经验类型必填")
    @Range(min = 1L, message = "经验类型Id不合法")
    private Long typeId;
    /**
     * 经验来源ID
     */
    private Long sourceId;
    private StrategyCaseDto source;

    /**
     * 标签
     */
    private String tags;
    private List<TagInfo> tagInfos;

    /**
     * 经验描述
     */
    @NotBlank(message = "描述必填")
    @Length(max = 1000, message = "描述过长，限制1000")
    private String description;

    /**
     * 有效用户&场景
     */
    @Length(max = 1000, message = "有效用户&场景过长，限制1000")
    private String validationTarget;

    /**
     * 有效性论证
     */
    @Length(max = 1000, message = "有效用户&场景过长，限制1000")
    private String validationProof;

    /**
     * 创建者姓名
     */
    private String creator;

    /**
     * 状态 0:待审核 1:审核通过 2:审核拒绝
     * {@link StrategyExperienceStatusEnum}
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 被应用在案例中的次数
     */
    private Integer relatedCaseCount;
    /**
     * 被应用在有效案例中的次数
     */
    private Integer relatedValidCaseCount;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTypeId() {
        return typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValidationTarget() {
        return validationTarget;
    }

    public void setValidationTarget(String validationTarget) {
        this.validationTarget = validationTarget;
    }

    public String getValidationProof() {
        return validationProof;
    }

    public void setValidationProof(String validationProof) {
        this.validationProof = validationProof;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getRelatedCaseCount() {
        return relatedCaseCount;
    }

    public void setRelatedCaseCount(Integer relatedCaseCount) {
        this.relatedCaseCount = relatedCaseCount;
    }

    public Integer getRelatedValidCaseCount() {
        return relatedValidCaseCount;
    }

    public void setRelatedValidCaseCount(Integer relatedValidCaseCount) {
        this.relatedValidCaseCount = relatedValidCaseCount;
    }

    public List<TagInfo> getTagInfos() {
        return tagInfos;
    }

    public void setTagInfos(List<TagInfo> tagInfos) {
        this.tagInfos = tagInfos;
    }

    public StrategyCaseDto getSource() {
        return source;
    }

    public void setSource(StrategyCaseDto source) {
        this.source = source;
    }
}