package cn.com.duiba.developer.center.api.remoteservice.survey;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.survey.SurveyDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.SurveyExportDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.SurveyExportResultDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.UserRecordDto;
import cn.com.duiba.developer.center.api.domain.enums.survey.SurveyStatusEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.survey.SurveyQueryParam;
import cn.com.duiba.developer.center.api.domain.paramquery.survey.SurveyUserRecordParam;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSurveyManagerService {
    PaginationVO<SurveyDto> findPageList(SurveyQueryParam param) throws BizException;

    SurveyDto findById(Long surveyId) throws BizException;

    SurveyDto detail(Long surveyId) throws BizException;

    /**
     * 保存问券
     */
    Long save(SurveyDto dto) throws BizException;

    /**
     * 更新问券状态
     */
    Boolean updateStatus(Long id, SurveyStatusEnum surveyStatusEnum) throws BizException;

    /**
     * 删除问券
     */
    Boolean delete(Long surveyId) throws BizException;


    /**
     * 导出问券
     */
    List<List<String>> export(Long surveyId) throws BizException;

    /**
     * 导出问券V2，header与content分开
     */
    SurveyExportResultDto exportV2(SurveyExportDto surveyExportDto) throws BizException;

    /**
     * 查询用户问券填写记录
     */
    List<UserRecordDto> findUserRecord(SurveyUserRecordParam userRecordParam) throws BizException;
}
