package cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool;

/**
 * Created by HePeng on 2018/10/29 14:32.
 */
public enum PerAmountLimitTypeEnum {
    TYPE_FIXED_AMOUNT(1, "固定额度"),
    TYPE_MIN_BALANCE(2, "账户余额至少多少"),
    TYPE_NO_LIMIT(10, "无限制"),
    ;

    private int code;
    private String desc;

    PerAmountLimitTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PerAmountLimitTypeEnum getByCode(Integer code) {
        if(code == null) {
            return null;
        }
        for (PerAmountLimitTypeEnum enumVal : PerAmountLimitTypeEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
