package cn.com.duiba.developer.center.api.remoteservice.duibaaccountinfo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.duibaaccountinfo.DuibaAccountInfoDto;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

/**
 * @Author 刘凯
 * @Date 2023/8/23 3:06 PM （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@AdvancedFeignClient
public interface RemoteDuibaAccountInfoService {

    /**
     * 分页查询 企业内部账户管理信息
     *
     * @param pageSize 分页大小
     * @param pageNum  分页条件
     * @param account  账户
     * @return 企业内部账户管理信息
     */
    PaginationVO<DuibaAccountInfoDto> selectDuibaAccountInfoPage(Integer pageSize, Integer pageNum, String account);

    /**
     * 新增企业内部账户
     *
     * @param duibaAccountInfoDto 企业内部账户信息
     * @return id
     */
    Long insert(DuibaAccountInfoDto duibaAccountInfoDto);

    /**
     * 修改企业内部账户
     *
     * @param duibaAccountInfoDto 企业内部账户信息
     * @return id
     */
    Long update(DuibaAccountInfoDto duibaAccountInfoDto);

    /**
     * 删除企业内部账户
     *
     * @param duibaAccountId id
     */
    void delete(Long duibaAccountId);

}
