package cn.com.duiba.developer.center.api.domain.dto.duibaaccountinfo;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业资产账户管理dto
 *
 * @author 杨祖波
 * @date 2023/8/24
 */
public class DuibaAccountInfoDto implements Serializable {

    private static final long serialVersionUID = 6424606497946532693L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 账号
     */
    private String account;
    /**
     * 类型 1 微信 2 支付宝 3 银联 4
     */
    private Integer type;
    /**
     * 环境 1 测试环境 2 生产环境
     */
    private Integer environment;
    /**
     * 账号申请人
     */
    private String applicant;
    /**
     * 账号管理员
     */
    private Long adminId;
    /**
     * 申请时间
     */
    private Date applyTime;
    /**
     * 过期时间
     */
    private Date expireTime;
    /**
     * 公司主体 1. 兑吧 2 兑啊 3 --
     */
    private Integer company;
    /**
     * 密码
     */
    private String password;
    /**
     * 密钥
     */
    private String secretKey;
    /**
     * 服务商ID
     */
    private String providerId;
    /**
     * 公钥
     */
    private String publicKey;
    /**
     * 商户ID
     */
    private String merchantId;
    /**
     * 额外字段
     */
    private String extraJson;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getEnvironment() {
        return environment;
    }

    public void setEnvironment(Integer environment) {
        this.environment = environment;
    }

    public String getApplicant() {
        return applicant;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getCompany() {
        return company;
    }

    public void setCompany(Integer company) {
        this.company = company;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }


}
