package cn.com.duiba.developer.center.api.domain.paramquery.domain;

import java.io.Serializable;
import javax.validation.constraints.NotNull;

/**
 * 创建app关联标签
 */
public class EditAppNewDomainQueryParams implements Serializable {
    private static final long serialVersionUID = -8640164431618251553L;

    /**
     * 域名前缀
     */
    @NotNull(message = "必须输入域名前缀")
    private String prefix;

    /**
     * 主键id
     */
    @NotNull(message = "必须选择app")
    private Long id;

    @NotNull(message = "必须指定开发者")
    private Long appId;

    @NotNull(message = "必须选择标签")
    private Long labelId;

    private Long optionId;

    private String optionName;

    public String getPrefix() {
        return prefix;
    }

    public EditAppNewDomainQueryParams setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Long getId() {
        return id;
    }

    public EditAppNewDomainQueryParams setId(Long id) {
        this.id = id;
        return this;
    }

    public Long getAppId() {
        return appId;
    }

    public EditAppNewDomainQueryParams setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public Long getLabelId() {
        return labelId;
    }

    public EditAppNewDomainQueryParams setLabelId(Long labelId) {
        this.labelId = labelId;
        return this;
    }

    public Long getOptionId() {
        return optionId;
    }

    public EditAppNewDomainQueryParams setOptionId(Long optionId) {
        this.optionId = optionId;
        return this;
    }

    public String getOptionName() {
        return optionName;
    }

    public EditAppNewDomainQueryParams setOptionName(String optionName) {
        this.optionName = optionName;
        return this;
    }
}
