package cn.com.duiba.developer.center.api.remoteservice.caselibrary;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.caselibrary.CaseLibraryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCaseLibraryService {
    /**
     * 新增案例
     * @param caseLibraryDto
     * @return
     */
    int insertCase(CaseLibraryDto caseLibraryDto);

    /**
     * 根据id查询案例
     * @param id
     * @return
     */
    CaseLibraryDto getCaseById(Long id);

    /**
     * 根据id更新案例
     * @param caseLibraryDto
     * @return
     */
    int updateCaseById(CaseLibraryDto caseLibraryDto);

    /**
     * 根据标题查询案例
     * @param caseTitle
     * @param caseIds
     * @return
     */
    List getCaseListByNameAndIds(String caseTitle, List<Long> caseIds);

    /**
     * 根据活动id 活动类型  校验
     * 返回存在的活动id
     * {@link ActivityUniformityTypeEnum#HDTool}  活动工具
     * {@link ActivityUniformityTypeEnum#CalendarSign}  日历签到
     * {@link ActivityUniformityTypeEnum#ManageSign}  经营性签到
     * {@link ActivityUniformityTypeEnum#PetSign}  宠物养成
     * {@link ActivityUniformityTypeEnum#ContractSign}  契约签到
     * @param activityType
     * @param activityIds
     * @return
     */
    List<Long> getActivityIdByActivityTypeAndId(Integer activityType, List<Long> activityIds);


    /**
     * 根据id删除案例
     * @param caseId
     * @param caseFirstSort
     * @param caseSecondSort
     * @param caseThirdSort
     * @return
     */
    int deleteCase(Long caseId,Integer caseFirstSort,Integer caseSecondSort,Integer caseThirdSort);
}
