package cn.com.duiba.developer.center.api.remoteservice.strategy;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyExperienceDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyExperienceDto;
import cn.com.duiba.developer.center.api.domain.paramquery.strategy.ExperienceQueryParam;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

/**
 * 经验-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
@AdvancedFeignClient
public interface RemoteStrategyExperienceService {
    /**
     * 新建经验
     *
     * @param experienceDto
     * @return
     */
    Long save(StrategyExperienceDto experienceDto) throws BizException;

    /**
     * 查询经验
     *
     * @param param
     * @return
     */
    PaginationVO<StrategyExperienceDto> findPageList(ExperienceQueryParam param) throws BizException;

    /**
     * 待审核的经验数量
     */
    Integer waitAuditCount() throws BizException;


    StrategyExperienceDetailDto detail(Long id) throws BizException;

    /**
     * 审核经验
     *
     * @param id
     * @param status
     * @return
     */
    Boolean audit(Long id, Integer status, String actorName) throws BizException;

    /**
     * 删除经验
     *
     * @param id        经验Id
     * @param actorName 操作人
     * @return
     */
    Boolean delete(Long id, String actorName) throws BizException;
}