package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;
import java.util.Date;

public class AppExceptionLogDto implements Serializable {//NOSONAR

	private static final long serialVersionUID = 8753935244658301147L;

	public static final int ConsumerCreditsType = 1;//NOSONAR 用户积分扣除接口

	public static final String ChargeModeMall = "mall";//NOSONAR
	public static final String ChargeModeApi = "api";//NOSONAR
	public static final String ChargeModeTurntable = "turntable";//NOSONAR 来自大转盘订单
	public static final String ChargeModeSingleLottery = "singlelottery"; //NOSONAR 来自单品抽奖
	public static final String ChargeModeManualLottery = "manuallottery";//NOSONAR 手工开奖
	public static final String ChargeModeHdtool = "hdtool"; //NOSONAR 活动工具
	public static final String ChargeModeGame = "game"; //NOSONAR 活动工具
	public static final String ChargeModeQuestion = "question"; //NOSONAR 答题活动
	public static final String ChargeModeQuizz = "quizz";//NOSONAR 测试题活动
	public static final String ChargeModeNgame = "ngame"; //NOSONAR 新游戏
	public static final String ChargeModeGuess = "guess"; //NOSONAR 竞猜
	public static final String ChargeModeActivity = "activity";//NOSONAR 新活动

	public static final int RelationTypeDefault = 0; //NOSONAR 普通订单
	public static final int RelationTypeActivity = 1; //NOSONAR 专题活动订单
	public static final int RelationTypeSingleLottery = 2; //NOSONAR 单品抽奖
	public static final int RelationTypeTurntable = 3;//NOSONAR 大转盘订单
	public static final int RelationTypeManualLottery = 4;//NOSONAR 手动开奖
	public static final int RelationTypeHdtool = 5; //NOSONAR 摇一摇
	public static final int RelationTypeHdtool2 = 6;//NOSONAR 刮一刮
	public static final int RelationTypeHdtoolTiger = 7;//NOSONAR 老虎机
	public static final int RelationTypeHdtoolTurntable = 8;//NOSONAR 活动工具幸运转盘
	public static final int RelationTypeHdtoolFlop = 11;//NOSONAR 趣味翻牌
	public static final int RelationTypeHdtoolSmashg = 12;//NOSONAR 砸彩蛋
	public static final int RelationTypeGameSanta = 20; //NOSONAR 圣诞老人
	public static final int RelationTypeGameMoney = 21; //NOSONAR 数钱游戏
	public static final int RelationTypeGameGirl = 22; //NOSONAR 女神pk
	public static final int RelationTypeGameJiong = 23; //NOSONAR 人在囧途
	public static final int RelationTypeQuestionMoney = 30; //NOSONAR 元宵答题
	public static final int RelationTypeQuizz = 41; //NOSONAR 测试题
	public static final int RelationTypeNgame = 28; //NOSONAR 新游戏
	public static final int RelationTypeGuess = 42; //NOSONAR 竞猜活动
	public static final int RelationTypeRob = 43;//NOSONAR 今日必抢


	private Long id;
	private Long orderId;
	private String orderNum;// 订单号
	private Long appId;
	private Long consumerId;
	private String url;
	private String errorMessage;
	private String respone;
	private Integer devExceptionType;// json,超时
	private Long relationId;// 关联对象id，如果ChargeMode=turntable，则此为大转盘订单id
	private Integer relationType;
	private Integer interfaceType;
	private String title;
	private Date gmtCreate;
	private Date gmtModified;
	private String developerBizId; // 开发者的业务id

	public AppExceptionLogDto() {
	}

	public AppExceptionLogDto(Long id) {
		this.id = id;
		this.gmtModified=new Date();
	}

	public AppExceptionLogDto(boolean init4insert) {
		if (init4insert) {
			relationType = RelationTypeDefault;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getRespone() {
		return respone;
	}

	public void setRespone(String respone) {
		if(respone!=null && respone.length()>3000){
			respone = respone.substring(0,3000);
		}
		this.respone = respone;
	}

	public Integer getDevExceptionType() {
		return devExceptionType;
	}

	public void setDevExceptionType(Integer devExceptionType) {
		this.devExceptionType = devExceptionType;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public Integer getInterfaceType() {
		return interfaceType;
	}

	public void setInterfaceType(Integer interfaceType) {
		this.interfaceType = interfaceType;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}


}
