package cn.com.duiba.developer.center.api.domain.dto.statistics;


import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

import com.google.common.collect.Lists;

/**
 * 统计每个积分段的数量
 */
public class OdpsAppCreditsDistributionDto implements Serializable {
	private static final long serialVersionUID = -213132126416L;

	private Long appId;
	private Long creditsRate;
	private Long period1;
	private Long period2;
	private Long period3;
	private Long period4;
	private Long period5;
	private Long period6;
	private Long period7;
	private Long period8;
	private Long period9;
	private Long period10;
	private Date day;

	/**
	 * 无参构造函数
	*/
	public OdpsAppCreditsDistributionDto(){
		this.day= new Date();
	}

	/**
	 * @param appId 应用
	 * @param day 日期
     */
	public OdpsAppCreditsDistributionDto(Long appId, Date day){
		this.appId=appId;
		this.day=day;
	}

	/**
	 * 各个积分段的详细情况
	 * @param appId 应用
	 * @param day 日期
	 */
	public OdpsAppCreditsDistributionDto(Long appId, Long creditsRate, Long period1, Long period2, Long period3, Long period4
			, Long period5, Long period6, Long period7, Long period8, Long period9, Long period10, Date day){//NOSONAR
		this.appId=appId;
		this.creditsRate=creditsRate;
		this.day=day;
		this.period1=period1;
		this.period2=period2;
		this.period3=period3;
		this.period4=period4;
		this.period5=period5;
		this.period6=period6;
		this.period7=period7;
		this.period8=period8;
		this.period9=period9;
		this.period10=period10;

	}
	

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getCreditsRate() {
		return creditsRate;
	}

	public void setCreditsRate(Long creditsRate) {
		this.creditsRate = creditsRate;
	}

	public Long getPeriod1() {
		return period1;
	}

	public void setPeriod1(Long period1) {
		this.period1 = period1;
	}

	public Long getPeriod2() {
		return period2;
	}

	public void setPeriod2(Long period2) {
		this.period2 = period2;
	}

	public Long getPeriod3() {
		return period3;
	}

	public void setPeriod3(Long period3) {
		this.period3 = period3;
	}

	public Long getPeriod4() {
		return period4;
	}

	public void setPeriod4(Long period4) {
		this.period4 = period4;
	}

	public Long getPeriod5() {
		return period5;
	}

	public void setPeriod5(Long period5) {
		this.period5 = period5;
	}

	public Long getPeriod6() {
		return period6;
	}

	public void setPeriod6(Long period6) {
		this.period6 = period6;
	}

	public Long getPeriod7() {
		return period7;
	}

	public void setPeriod7(Long period7) {
		this.period7 = period7;
	}

	public Long getPeriod8() {
		return period8;
	}

	public void setPeriod8(Long period8) {
		this.period8 = period8;
	}

	public Long getPeriod9() {
		return period9;
	}

	public void setPeriod9(Long period9) {
		this.period9 = period9;
	}

	public Long getPeriod10() {
		return period10;
	}

	public void setPeriod10(Long period10) {
		this.period10 = period10;
	}

	public Date getDay() {
		return day;
	}

	public void setDay(Date day) {
		this.day = day;
	}

	/**
	 * 获取积分段参数
	 * @return 积分段列表
     */
	public List<CreditsDistributionDto> getCreditsDistribution(){
		DecimalFormat df = new DecimalFormat("#0");
		DecimalFormat df1 = new DecimalFormat("#0.0");
		List<CreditsDistributionDto> result = Lists.newArrayList();
		result.add(new CreditsDistributionDto(convertCreditsUnit(100*creditsRate)+"-∞",period10));
		result.add(new CreditsDistributionDto(convertCreditsUnit(50*creditsRate)+"-"+convertCreditsUnit(100*creditsRate-1),period9));
		result.add(new CreditsDistributionDto(convertCreditsUnit(10*creditsRate)+"-"+convertCreditsUnit(50*creditsRate-1),period8));
		result.add(new CreditsDistributionDto(convertCreditsUnit(5*creditsRate)+"-"+convertCreditsUnit(10*creditsRate-1),period7));
		result.add(new CreditsDistributionDto(convertCreditsUnit(2*creditsRate)+"-"+convertCreditsUnit(5*creditsRate-1),period6));
		result.add(new CreditsDistributionDto(convertCreditsUnit(1*creditsRate)+"-"+convertCreditsUnit(2*creditsRate-1),period5));
		if (creditsRate < 100000 && creditsRate >= 10 && creditsRate % 10 == 0) {
			result.add(new CreditsDistributionDto(df.format(0.5*creditsRate)+"-"+convertCreditsUnit(1*creditsRate-1),period4));
			result.add(new CreditsDistributionDto(df.format(0.2*creditsRate)+"-"+df.format(0.5*creditsRate-1),period3));
			result.add(new CreditsDistributionDto(df.format(0.1*creditsRate)+"-"+df.format(0.2*creditsRate-1),period2));
			result.add(new CreditsDistributionDto(0+"-"+df.format(0.1*creditsRate-1),period1));
		}else if(creditsRate >= 100000 && creditsRate % 10 == 0){
			result.add(new CreditsDistributionDto(convertCreditsUnit(Long.parseLong(df.format(0.5*creditsRate)))+"-"+convertCreditsUnit(1*creditsRate-1),period4));
			result.add(new CreditsDistributionDto(convertCreditsUnit(Long.parseLong(df.format(0.2*creditsRate)))+"-"+convertCreditsUnit(Long.parseLong(df.format(0.5*creditsRate-1))),period3));
			result.add(new CreditsDistributionDto(convertCreditsUnit(Long.parseLong(df.format(0.1*creditsRate)))+"-"+convertCreditsUnit(Long.parseLong(df.format(0.2*creditsRate-1))),period2));
			result.add(new CreditsDistributionDto(0+"-"+convertCreditsUnit(Long.parseLong(df.format(0.1*creditsRate-1))),period1));
		}else{
			result.add(new CreditsDistributionDto(df1.format(0.5*creditsRate)+"-"+convertCreditsUnit(1*creditsRate-1),period4));
			result.add(new CreditsDistributionDto(df1.format(0.2*creditsRate)+"-"+df1.format(0.5*creditsRate-1),period3));
			result.add(new CreditsDistributionDto(df1.format(0.1*creditsRate)+"-"+df1.format(0.2*creditsRate-1),period2));
			result.add(new CreditsDistributionDto(0+"-"+df1.format(0.1*creditsRate-1),period1));
		}
		
		return result;
	}
	
	@Override
	public String toString() {
		return "appId="+appId+",day="+day;
	}

	
	/**
	 * 积分单位转换，如果大于1W，转换为XXX万
	 * @param credits 积分
	 * @return 格式化之后的积分
	 */
	public String convertCreditsUnit(Long credits) {
		String ret;
		if (credits < 1000000 && credits >= 10000 && credits % 1000 == 0) {
			ret = new BigDecimal(credits).divide(new BigDecimal(10000)) + "万";
		}else if (credits < 10000000 && credits >= 1000000 && credits % 100000 == 0) {
			ret = new BigDecimal(credits).divide(new BigDecimal(1000000)) + "百万";
		}else if (credits < 100000000 && credits >= 10000000 && credits % 1000000 == 0) {
			ret = new BigDecimal(credits).divide(new BigDecimal(10000000)) + "千万";
		}else if (credits >= 100000000 && credits % 10000000 == 0) {
			ret = new BigDecimal(credits).divide(new BigDecimal(100000000)) + "亿";
		} else {
			ret = credits + "";
		}
		return ret;
	}
}
