package cn.com.duiba.developer.center.api.domain.dto.floorconfig;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import cn.com.duiba.developer.center.api.domain.enums.ChildPageTargetEnum;

/**
 * Created by liuyao on 16/8/24.
 */
public class CouponJson extends BaseJson {

    private static final long serialVersionUID = 8842249517649365283L;
    /** 楼层标题 */
    @NotNull
    private String floorTitle = "优惠券";
    /** 点击后跳转目标 {@see ChildPageTargetEnum} */
    private String target = ChildPageTargetEnum.GO_TO_SUB_PAGE.getCode();
    /** 展示数量 */
    @NotNull
    @Min(value=2)
    @Max(value=6)
    private Integer showNum = 6;

    public String getFloorTitle() {
        return floorTitle;
    }

    public void setFloorTitle(String floorTitle) {
        this.floorTitle = floorTitle;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Integer getShowNum() {
        return showNum;
    }

    public void setShowNum(Integer showNum) {
        this.showNum = showNum;
    }
}
