package cn.com.duiba.developer.center.api.remoteservice.authority;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListDto;
import cn.com.duiba.developer.center.api.domain.param.authority.WhiteListParam;
import cn.com.duiba.developer.center.api.domain.paramquery.whitelist.WhiteListRequest;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBusinessWhiteListService {

    void createHandler(WhiteListParam whiteListParam) throws BizException;

    void updateHandler(WhiteListParam whiteListParam) throws BizException;

    Long save(BusinessWhiteListDto businessWhiteListDto);

    Integer deleteById(Long id);

    Integer updateById(BusinessWhiteListDto businessWhiteListDto);

    BusinessWhiteListDto getById(Long id);

    List<BusinessWhiteListDto> listByIds(List<Long> ids);

    BusinessWhiteListDto getByCode(String uniqueCode);
    @Deprecated
    List<BusinessWhiteListDto> listPageByCodesAndBizName(List<String> uniqueCodes,String bizName,Integer pageNo,Integer pageSize);

    List<BusinessWhiteListDto> listPageByWhiteListRequest(WhiteListRequest whiteListRequest);

    Long listPageCountByWhiteListRequest(WhiteListRequest whiteListRequest);

    @Deprecated
    Long listPageByCodesAndBizNameCount(List<String> uniqueCodes,String bizName);

}
