package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueContractInfoDto;

import java.util.List;

/**
 * @author haojiahong
 * @date 2020-06-17
 */
@AdvancedFeignClient
public interface RemoteClueContractInfoService {
    /**
     * 【联系人信息】通过客户线索id，获取联系人信息
     *
     * @param clueId
     * @return
     */
    List<ClueContractInfoDto> getContractListByClueId(Long clueId);

    /**
     * 【联系人信息】通过记录id，获取联系人信息
     *
     * @param id
     * @return
     */
    ClueContractInfoDto getContractById(Long id);

    /**
     * 【联系人信息】添加or编辑联系人信息
     *
     * @param pojo
     * @return
     */
    Boolean saveContract(ClueContractInfoDto pojo);

}
