/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.dto.statistics;

import cn.com.duiba.developer.center.api.domain.dto.statistics.CreditsDistributionDto;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OdpsAppCreditsDistributionDto
implements Serializable {
    private static final long serialVersionUID = -213132126416L;
    private Long appId;
    private Long creditsRate;
    private Long period1;
    private Long period2;
    private Long period3;
    private Long period4;
    private Long period5;
    private Long period6;
    private Long period7;
    private Long period8;
    private Long period9;
    private Long period10;
    private Date day;

    public OdpsAppCreditsDistributionDto() {
        this.day = new Date();
    }

    public OdpsAppCreditsDistributionDto(Long appId, Date day) {
        this.appId = appId;
        this.day = day;
    }

    public OdpsAppCreditsDistributionDto(Long appId, Long creditsRate, Long period1, Long period2, Long period3, Long period4, Long period5, Long period6, Long period7, Long period8, Long period9, Long period10, Date day) {
        this.appId = appId;
        this.creditsRate = creditsRate;
        this.day = day;
        this.period1 = period1;
        this.period2 = period2;
        this.period3 = period3;
        this.period4 = period4;
        this.period5 = period5;
        this.period6 = period6;
        this.period7 = period7;
        this.period8 = period8;
        this.period9 = period9;
        this.period10 = period10;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getCreditsRate() {
        return this.creditsRate;
    }

    public void setCreditsRate(Long creditsRate) {
        this.creditsRate = creditsRate;
    }

    public Long getPeriod1() {
        return this.period1;
    }

    public void setPeriod1(Long period1) {
        this.period1 = period1;
    }

    public Long getPeriod2() {
        return this.period2;
    }

    public void setPeriod2(Long period2) {
        this.period2 = period2;
    }

    public Long getPeriod3() {
        return this.period3;
    }

    public void setPeriod3(Long period3) {
        this.period3 = period3;
    }

    public Long getPeriod4() {
        return this.period4;
    }

    public void setPeriod4(Long period4) {
        this.period4 = period4;
    }

    public Long getPeriod5() {
        return this.period5;
    }

    public void setPeriod5(Long period5) {
        this.period5 = period5;
    }

    public Long getPeriod6() {
        return this.period6;
    }

    public void setPeriod6(Long period6) {
        this.period6 = period6;
    }

    public Long getPeriod7() {
        return this.period7;
    }

    public void setPeriod7(Long period7) {
        this.period7 = period7;
    }

    public Long getPeriod8() {
        return this.period8;
    }

    public void setPeriod8(Long period8) {
        this.period8 = period8;
    }

    public Long getPeriod9() {
        return this.period9;
    }

    public void setPeriod9(Long period9) {
        this.period9 = period9;
    }

    public Long getPeriod10() {
        return this.period10;
    }

    public void setPeriod10(Long period10) {
        this.period10 = period10;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public List<CreditsDistributionDto> getCreditsDistribution() {
        DecimalFormat df = new DecimalFormat("#0");
        DecimalFormat df1 = new DecimalFormat("#0.0");
        ArrayList result = Lists.newArrayList();
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(100L * this.creditsRate) + "-\u221e", this.period10));
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(50L * this.creditsRate) + "-" + this.convertCreditsUnit(100L * this.creditsRate - 1L), this.period9));
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(10L * this.creditsRate) + "-" + this.convertCreditsUnit(50L * this.creditsRate - 1L), this.period8));
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(5L * this.creditsRate) + "-" + this.convertCreditsUnit(10L * this.creditsRate - 1L), this.period7));
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(2L * this.creditsRate) + "-" + this.convertCreditsUnit(5L * this.creditsRate - 1L), this.period6));
        result.add(new CreditsDistributionDto(this.convertCreditsUnit(1L * this.creditsRate) + "-" + this.convertCreditsUnit(2L * this.creditsRate - 1L), this.period5));
        if (this.creditsRate < 100000L && this.creditsRate >= 10L && this.creditsRate % 10L == 0L) {
            result.add(new CreditsDistributionDto(df.format(0.5 * (double)this.creditsRate.longValue()) + "-" + this.convertCreditsUnit(1L * this.creditsRate - 1L), this.period4));
            result.add(new CreditsDistributionDto(df.format(0.2 * (double)this.creditsRate.longValue()) + "-" + df.format(0.5 * (double)this.creditsRate.longValue() - 1.0), this.period3));
            result.add(new CreditsDistributionDto(df.format(0.1 * (double)this.creditsRate.longValue()) + "-" + df.format(0.2 * (double)this.creditsRate.longValue() - 1.0), this.period2));
            result.add(new CreditsDistributionDto("0-" + df.format(0.1 * (double)this.creditsRate.longValue() - 1.0), this.period1));
        } else if (this.creditsRate >= 100000L && this.creditsRate % 10L == 0L) {
            result.add(new CreditsDistributionDto(this.convertCreditsUnit(Long.parseLong(df.format(0.5 * (double)this.creditsRate.longValue()))) + "-" + this.convertCreditsUnit(1L * this.creditsRate - 1L), this.period4));
            result.add(new CreditsDistributionDto(this.convertCreditsUnit(Long.parseLong(df.format(0.2 * (double)this.creditsRate.longValue()))) + "-" + this.convertCreditsUnit(Long.parseLong(df.format(0.5 * (double)this.creditsRate.longValue() - 1.0))), this.period3));
            result.add(new CreditsDistributionDto(this.convertCreditsUnit(Long.parseLong(df.format(0.1 * (double)this.creditsRate.longValue()))) + "-" + this.convertCreditsUnit(Long.parseLong(df.format(0.2 * (double)this.creditsRate.longValue() - 1.0))), this.period2));
            result.add(new CreditsDistributionDto("0-" + this.convertCreditsUnit(Long.parseLong(df.format(0.1 * (double)this.creditsRate.longValue() - 1.0))), this.period1));
        } else {
            result.add(new CreditsDistributionDto(df1.format(0.5 * (double)this.creditsRate.longValue()) + "-" + this.convertCreditsUnit(1L * this.creditsRate - 1L), this.period4));
            result.add(new CreditsDistributionDto(df1.format(0.2 * (double)this.creditsRate.longValue()) + "-" + df1.format(0.5 * (double)this.creditsRate.longValue() - 1.0), this.period3));
            result.add(new CreditsDistributionDto(df1.format(0.1 * (double)this.creditsRate.longValue()) + "-" + df1.format(0.2 * (double)this.creditsRate.longValue() - 1.0), this.period2));
            result.add(new CreditsDistributionDto("0-" + df1.format(0.1 * (double)this.creditsRate.longValue() - 1.0), this.period1));
        }
        return result;
    }

    public String toString() {
        return "appId=" + this.appId + ",day=" + this.day;
    }

    public String convertCreditsUnit(Long credits) {
        String ret = credits < 1000000L && credits >= 10000L && credits % 1000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(10000)) + "\u4e07" : (credits < 10000000L && credits >= 1000000L && credits % 100000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(1000000)) + "\u767e\u4e07" : (credits < 100000000L && credits >= 10000000L && credits % 1000000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(10000000)) + "\u5343\u4e07" : (credits >= 100000000L && credits % 10000000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(100000000)) + "\u4ebf" : credits + "")));
        return ret;
    }
}

