package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

import org.apache.commons.lang.ObjectUtils;

/**
 * Created by dugq on 2018/9/1 0001.
 */
public enum OpenStatusEnum {
    OPEN(1,"启用"),CLOSE(0,"关闭");

    private String desc;
    private Integer code;

    OpenStatusEnum( Integer code,String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static OpenStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OpenStatusEnum openStatusEnum : OpenStatusEnum.values()) {
            if (ObjectUtils.equals(code, openStatusEnum.getCode())) {
                return openStatusEnum;
            }
        }
        return null;
    }
}
