package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.ItemActivityExtSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListContentSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListSimpleDto;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 央视频本地化定制专用remote
 */
@AdvancedFeignClient
public interface RemoteYspLocalDevelopCenterService {
    /**
     * 查询活动扩展信息
     */
    ItemActivityExtSimpleDto findItemActivityExtByItemId(Long itemId);

    /**
     * 保存或更新活动扩展信息
     */
    void saveOrUpdateItemActivityExt(ItemActivityExtSimpleDto dto);


    /**
     * 查询业务白名单列表
     */
    BusinessWhiteListSimpleDto findBusinessWhiteListByUniqueCode(String uniqueCode);

    /**
     * 查询业务白名单内容
     */
    List<BusinessWhiteListContentSimpleDto> findBusinessWhiteListContentByRelId(Long relId);

    /**
     * 保存或更新业务白名单
     */
    void saveOrUpdateBusinessWhite(JSONObject data);
}
