package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Author: lufeng
 * @Description: 策略库项目来源枚举
 * @Date: Created in 2020/7/21
 */
public enum OriginTypeEnum {

    PROJECTX(1, "星速台"),
    CMS(2, "cms后台"),
    MNG(3, "mng后台"),
    OTHER(4, "其他");

    private Integer code;

    private String desc;

    OriginTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        if (Objects.isNull(code)){
            return "";
        }
        OriginTypeEnum payTypeEnum = getByCode(code);
        if (Objects.nonNull(payTypeEnum)){
            return payTypeEnum.getDesc();
        }
        return "";
    }

    public static OriginTypeEnum getByCode(Integer code){
        return Arrays.stream(OriginTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public static boolean isExist(Integer code){
        return Objects.nonNull(code) &&
                Arrays.stream(OriginTypeEnum.values()).anyMatch(a -> a.code.equals(code));
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
