package cn.com.duiba.developer.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppExceptionLogDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppExceptionLogQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
@AdvancedFeignClient
public interface RemoteAppExceptionLogService {

	public DubboResult<List<AppExceptionLogDto>> findListByAppIdAndDay(Long appId, String startDate, String endDate, Integer start, Integer pageSize);

	public DubboResult<List<AppExceptionLogDto>> findListByAppIdAndDayAndExcepType(Long appId, String startDate, String endDate, Long excepType, Integer start, Integer pageSize);

	public DubboResult<Long> getCountByAppIdAndDay(Long appId, String startDate, String endDate);
	
	public DubboResult<Long> getCountByAppIdAndDayAndExcepType(Long appId, String startDate, String endDate, Long excepType);

	public DubboResult<List<AppExceptionLogDto>> findByAppIdAndOrderNum(Long appId, String orderNum);

	public DubboResult<List<AppExceptionLogDto>> findByOrderNumList(List<String> orderNums);
	
	public DubboResult<Integer> insert(AppExceptionLogDto appExceptionLogDO);

	/**
	 * 分页查询app异常列表
	 * @param param
	 * @return
	 */
	public  List<AppExceptionLogDto> queryExceptionLogPage(AppExceptionLogQueryParam param);

	public  Long  queryExceptionLogPageCount(AppExceptionLogQueryParam param);

	public  List<AppExceptionLogDto> findAppExceptionLogListByIds(List<Long> ids);

	public  Boolean  deleteAppExceptionLog(List<Long> ids);

	/**
	 * 查询最近一条异常日志
	 * @param appId 应用id
	 * @param interfaceType
	 * @return
	 */
	 AppExceptionLogDto queryLatestExceptionLog(Long appId, Integer interfaceType);

	/**
	 * 查询最近一个时间段的异常数量
	 * @param appId
	 * @param interfaceType
	 * @param startTime
	 * @return
	 */
	 Integer queryCountDuringPeriod(Long appId, Integer interfaceType, Date startTime);
}
