package cn.com.duiba.developer.center.api.domain.enums;

/**
 * 策略后台动态数据类型枚举 <br>
 *
 * @author: xuwei
 * @date: 2020/5/27
 */
public enum StrategyDynamicDataTypeEnum {
    INDUSTRY(10, "行业"),
    INDUSTRY_TYPE(1000, "行业分类"),
    CUSTOMER(1001, "客户"),
    INDICATOR(1002, "经营指标"),
    PLAYWAY_TYPE(11, "玩法类型", true),
    PLAYWAY_MODULE(12, "组件", true),
    CHANNEL(13, "投放渠道"),
    USER_TYPE(14, "面向用户"),
    EXPECT_GOAL(15, "预期目标"),
    EXPERIENCE_TYPE(16, "经验类型"),
    EXPERIENCE_TAG(17, "经验标签"),
    ;

    public static StrategyDynamicDataTypeEnum of(Integer type) {
        if (type == null) {
            return null;
        }
        for (StrategyDynamicDataTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }

    Integer type;
    String name;
    boolean other;

    StrategyDynamicDataTypeEnum(int type, String name) {
        this(type, name, false);
    }

    StrategyDynamicDataTypeEnum(int type, String name, boolean other) {
        this.type = type;
        this.name = name;
        this.other = other;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public boolean hasOther() {
        return other;
    }
}
