package cn.com.duiba.developer.center.api.domain.param;

import cn.com.duiba.developer.center.api.domain.enums.risk.RiskWhiteListSenceEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;


/**
 * 白名单匹配参数
 */
public class RiksWhitelistMatchingParam implements Serializable {

    private static final long serialVersionUID = 6759233699458815114L;

    /**
     * 应用ID（必填 强验证）
     */
    private Long appId;

    /**
     * 用户ID（必填 强验证）
     */
    private Long consumerId;

    /**
     * IP地址（必填 强验证）
     */
    private String ip;

    /**
     * 风控场景
     * {@link cn.com.duiba.developer.center.api.domain.enums.risk.RiskWhiteListSenceEnum}
     */
    private RiskWhiteListSenceEnum riskSence;


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public RiskWhiteListSenceEnum getRiskSence() {
        return riskSence;
    }

    public void setRiskSence(RiskWhiteListSenceEnum riskSence) {
        this.riskSence = riskSence;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
