package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum ClueCarrierInfoEnum {


    UNKNOWN(1,"未知"),
    APP(2,"app"),
    OFFICIALACCOUNTS(3,"公众号"),
    MINIPROGRAM(4,"小程序");


    private static final Map<Integer, ClueCarrierInfoEnum> enumMap = new HashMap<>();
    static{
        for(ClueCarrierInfoEnum clueCarrierInfoEnum : values()){
            enumMap.put(clueCarrierInfoEnum.getCode(), clueCarrierInfoEnum);
        }
    }

    public static ClueCarrierInfoEnum getByCode(Integer code){
        ClueCarrierInfoEnum clueCarrierInfoEnum = enumMap.get(code);
        if(clueCarrierInfoEnum == null){
            return null;
        }
        return clueCarrierInfoEnum;
    }

    ;

    private Integer code;
    private String desc;

    ClueCarrierInfoEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
