package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasDateLimitTypeEnum {
    /**
     * 期限类型，期限类型，1：日；2：周；3：月；4：季度；5：年；
     * dateLimitType
     */
    DAY(1,"日"),
    WEEK(2,"周"),
    MONTH(3,"月"),
    QUARTER(4,"季度"),
    YEAR(5,"年"),
    FOR_EVER(6,"永久"),
    HALF_YEAR(7,"半年"),
    FOLLOW_NEW_VERSION(8,"跟随新版本时间");

    private static final Map<Integer, SaasDateLimitTypeEnum> enumMap = new HashMap<>();
    static{
        for(SaasDateLimitTypeEnum saasDateLimitTypeEnum : values()){
            enumMap.put(saasDateLimitTypeEnum.getValue(), saasDateLimitTypeEnum);
        }
    }

    public static SaasDateLimitTypeEnum getByCode(Integer code){
        SaasDateLimitTypeEnum saasDateLimitTypeEnum = enumMap.get(code);
        if(saasDateLimitTypeEnum == null){
            throw new DeveloperCenterException("不支持的期限类型");
        }
        return saasDateLimitTypeEnum;
    }

    private int    value;
    private String desc;

    SaasDateLimitTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
