package cn.com.duiba.developer.center.api.remoteservice.mainmeet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.mainmeet.MainMeetConfigDto;
import cn.com.duiba.developer.center.api.domain.dto.mainmeet.MainMeetConsumerDto;
import cn.com.duiba.developer.center.api.domain.dto.mainmeet.MainMeetThemeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/1/22.
 * 主会场服务
 */
@AdvancedFeignClient
public interface RemoteMainMeetService {

    /**
     * web端获取的主会场配置(高并发)
     * @param id
     * @return
     */
    public DubboResult<MainMeetConsumerDto> findMainMeetConsumerDto(Long id);
    /**
     * 获取单个主会场配置
     * @param id
     * @return
     */
    public DubboResult<MainMeetConfigDto> find(Long id);

    /**
     * 加载主会场分页列表(缺省 activityConfig)
     * @param params
     * @return
     */
    public DubboResult<PaginationVO<MainMeetConfigDto>> findMainMeetPage(PageQueryEntity params);

    /**
     * 删除主会场
     * @param id
     * @return
     */
    public DubboResult<Integer> deleteMainMeet(Long id);

    /**
     * 保存主会场
     * @param mainmeet
     * @return 主会场Id
     */
    public DubboResult<Long> submitMainMeet(MainMeetConfigDto mainmeet);

    /**
     * 查询主会场皮肤
     * @param id
     * @return
     */
    public DubboResult<MainMeetThemeDto> findTheme(Long id);

    /**
     * 保存主会场皮肤
     * @param theme
     * @return
     */
    public DubboResult<Long> submitTheme(MainMeetThemeDto theme);

    /**
     * 获取皮肤分页列表(字段缺省 activityList)
     * @param params
     * @return
     */
    public DubboResult<PaginationVO<MainMeetThemeDto>> findThemePage(PageQueryEntity params);

    /**
     * 变更主会场状态
     * @param id
     * @param status
     * @return
     */
    public DubboResult<Boolean> updataThemeStatus(Long id,Integer status);

    /**
     * 加载未被隐藏的皮肤列表
     * @return
     */
    public DubboResult<List<MainMeetThemeDto>> findThemeListButHide();

}
