package cn.com.duiba.developer.center.api.domain.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 经验状态枚举
 *
 * @author zengsp
 */

public enum StrategyExperienceStatusEnum {
    INIT(0, "待审核"),
    PASS(1, "审核通过"),
    REJECT(2, "审核拒绝"),
    ;
    int code;
    String msg;

    StrategyExperienceStatusEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, StrategyExperienceStatusEnum> CACHE =
            Arrays.stream(StrategyExperienceStatusEnum.values())
                    .collect(Collectors.toMap(StrategyExperienceStatusEnum::getCode, Function.identity()));

    public static StrategyExperienceStatusEnum of(int code) {
        return CACHE.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
