package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.redpacketsmanagetool.RedpacketsManageToolDto;
import cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool.StatusEnum;

/**
 * 红包管理工具
 * Created by HePeng on 2018/10/29 16:35.
 */
@AdvancedFeignClient
public interface RemoteRedpacketsManageToolService {
    /**
     * 保存配置（新增或修改）
     * @param redpacketsManageToolDto
     * @return
     */
    Long saveRedpacketsManageTool(RedpacketsManageToolDto redpacketsManageToolDto) throws BizException;

    /**
     * 通过appId获取配置
     * @param appId
     * @return
     */
    RedpacketsManageToolDto getRedpacketManageToolByAppId(Long appId);

    /**
     * 通过appId获取配置，有缓存
     * @param appId
     * @return
     */
    RedpacketsManageToolDto getCachedRedpacketManageToolByAppId(Long appId);

    /**
     * 通过appId修改配置状态
     * @param appId
     * @param statusEnum
     * @return
     */
    boolean updateStatusByAppId(Long appId, StatusEnum statusEnum);

    /**
     * 通过appId扣除今日剩余额度（负数表示补上）
     * @param appId
     * @param decreaseAmount
     * @return
     */
    boolean decreaseTodayLeftAmountByAppId(Long appId, Long decreaseAmount);

    /**
     * 初始化所有app今日剩余额度
     * @return
     */
    Integer initTodayLeftAmount();
}
