/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.survey.OptionDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.QuestionDto;
import java.util.List;
import java.util.Objects;

public class QuestionDiffTool {
    public static boolean diff(List<QuestionDto> beforeQuestions, List<QuestionDto> afterQuestions) {
        if (beforeQuestions.size() != afterQuestions.size()) {
            return true;
        }
        for (int i = 0; i < beforeQuestions.size(); ++i) {
            if (!QuestionDiffTool.diffQuestion(beforeQuestions.get(i), afterQuestions.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean diffQuestion(QuestionDto before, QuestionDto after) {
        if (Objects.equals(before.getCode(), after.getCode())) {
            return true;
        }
        if (Objects.equals(before.getTitle(), after.getTitle())) {
            return true;
        }
        if (Objects.equals(before.getDescription(), after.getDescription())) {
            return true;
        }
        if (Objects.equals(before.getRequired(), after.getRequired())) {
            return true;
        }
        if (Objects.equals(before.getValidate(), after.getValidate())) {
            return true;
        }
        if (Objects.equals(before.getDisplay(), after.getDisplay())) {
            return true;
        }
        if (Objects.equals(before.getJump(), after.getJump())) {
            return true;
        }
        return QuestionDiffTool.diffOptions(before.getOptions(), after.getOptions());
    }

    private static boolean diffOptions(List<OptionDto> beforeOptions, List<OptionDto> afterOptions) {
        if (beforeOptions.size() != afterOptions.size()) {
            return true;
        }
        for (int i = 0; i < beforeOptions.size(); ++i) {
            if (!QuestionDiffTool.diffOption(beforeOptions.get(i), afterOptions.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean diffOption(OptionDto before, OptionDto after) {
        if (Objects.equals(before.getCode(), after.getCode())) {
            return true;
        }
        if (Objects.equals(before.getText(), after.getText())) {
            return true;
        }
        if (Objects.equals(before.getType(), after.getText())) {
            return true;
        }
        if (Objects.equals(before.getDisplay(), after.getDisplay())) {
            return true;
        }
        if (Objects.equals(before.getJump(), after.getJump())) {
            return true;
        }
        return Objects.equals(before.getExclusive(), after.getExclusive());
    }
}

