package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.url.AppLabelDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.url.NewDomainReductionDto;
import cn.com.duiba.developer.center.api.domain.dto.url.NewDomainUrlDto;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.AppNewDomainQueryParams;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.CreateAppNewDomainQueryParams;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.NewDomainLabelParams;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.EditAppNewDomainQueryParams;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.NewDomainQueryParams;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNewDomainService {


    boolean careteNewDomain(String url, Integer status) throws BizException;

    boolean updateNewDomain (Integer status, Long id);

    boolean deleteNewDomain (Long id) throws BizException;

    /**
     * 根据条件分页查询新域名
     * @param newDomainQueryParams
     * @return
     */
    Page<NewDomainUrlDto> seachNewDomain (NewDomainQueryParams newDomainQueryParams);

    /**
     * 根据urlid 查询app信息
     * @param id
     * @return
     */
    List<AppLabelDetailDto> queryAppByUrlId(Long id);


    boolean careteLabel(NewDomainLabelParams params) throws BizException;

    boolean updateLabel(NewDomainLabelParams params) throws BizException;

    boolean deleteLabel(Long id);

    /**
     * 一键还原
     * @param appIds
     * @return
     */
    NewDomainReductionDto reductionDomain(List<Long> appIds) throws BizException;

    /**
     * 根据appId或标签id批量查询
     *
     * @param params
     * @return
     */
    public Page<AppLabelDetailDto> queryNewDomainLabelByAppOrLabelId(AppNewDomainQueryParams params);

    /**
     * 添加app
     *
     * @return
     */
    boolean insetAppLabelDetail(CreateAppNewDomainQueryParams params) throws BizException;

    /**
     * 修改app
     *
     * @return
     */
    Integer updateAppLabelDetailEntity(EditAppNewDomainQueryParams params);
}
