package cn.com.duiba.developer.center.api.utils;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * <p/>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {//NOSONAR
    K001("兑吧微信活动web域名"),
    K002("推啊微信活动web域名"),
    k003("APP广告位关系"),
    k004("开发者信用接口"),
    K005("SAAS限流"),
    K006("app对应域名组"),
    K007("域名组对应域名"),
    K008("积分商城内页定制"),
    //多加点key值怕重复
    K017("可视化页面及组件列表信息"),
    K018("可视化页面图片库信息"),
    K019("开发者图片库"),
    K020("可视化备份页面及组件列表信息"),
    K021("可视化组件编辑锁单个皮肤"),

    K030("app红包运营工具配置"),
    K031("app红包运营工具今日剩余提现额度"),
    K032("红包运营工具今日剩余提现额度初始化标记"),
    K033("組件化浮标配置"),
    K034("app拓展大字段 防止并發插入key"),
    K035("app拓展大字段 缓存key"),

    K040("校验app账户风控预警配置"),
    K041("校验奖品发放预警配置"),

    K042("风控白名单"),
    K043("通用模板组件"),

    K044("问券用户锁"),
    K045("manager-web用户反馈问券答案导出"),
    K046("cms-web用户反馈问券答案导出"),

    K047("链接券反向代理锁"),


    //新的域名规则
    K048("newapp对应域名组"),
    K049("标签锁"),

    ;

    /**
     * 开发者中心:developer-center
     */
    private static final String SPACE = "DC";

    private static final String SEPARATOR = "_";

    private String description;

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 生成唯一的rediskey
     *
     * @param obj 一般是id
     * @return
     */
    public String getKey(Object obj) {
        return new StringBuilder(SPACE).append(SEPARATOR).append(super.toString()).append(SEPARATOR).append(obj).toString();
    }

    private RedisKeyFactory(String description) {
        this.description = description;
    }

}
