package cn.com.duiba.developer.center.api.domain.dto;

import com.google.common.collect.ImmutableSet;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

/**
 * @author sunyan
 * @version 创建时间：2017年4月12日 下午2:50:53
 */
public class AppNewExtraDto implements Serializable {//NOSONAR
    private static final long serialVersionUID = -8083052631355120698L;

    public static final String SEC_KILL_VALIDATION_SLIDE = "1"; //秒杀滑动类型验证码
    public static final String SEC_KILL_VALIDATION_CLICK = "2"; //秒杀点击类型验证码
    public static final String EXCHANGE_VALIDATION_SLIDE = "1"; //普兑滑动类型验证码
    public static final String EXCHANGE_VALIDATION_CLICK = "2"; //普兑点击类型验证码

    public static final Integer CREATE_SOURCE_CREDITS = 0;//商城
    public static final Integer CREATE_SOURCE_AD = 1;//广告

    public static final String  APP_ID = "appId";
    public static final String _BD = "bd";//bd联系人
    public static final String DAILY_ACT_LOGIN_UV = "dailyActLoginUv";//上月日均活动登录UV
    public static final String ONLINE_DATE = "onlineDate";//上线日期
    public static final String FLOW_RULE = "flowRule";
    public static final String COUPON_STOCK_WARN = "couponStockWarn";//自有优惠券/虚拟商品库存预警线
    public static final String OBJECT_STOCK_WARN = "objectStockWarn";//自有实物库存预警线
    public static final String NOT_LOGIN_PLAY_GAME = "notLoginPlayGame";//未登录是否可以参与游戏
    public static final String SEC_KILL_VALIDATION_KEY = "secKillValidation"; //秒杀验证码类型
    public static final String EXCHANGE_VALIDATION_KEY = "exchangeValidation"; //普兑验证码类型
    public static final String CONSUME_VIRTUAL_CARD = "consumeVirtualCard";//扣虚拟卡链接key
    public static final String CONSUME_VIRTUAL_CARD_NOTIFY = "consumeVirtualCardNotify";//扣虚拟卡链接key
    public static final String FLOW_VIEW_TIME="flowViewTime";//流量策略展示时间key
    public static final String FLOW_RULE_GOOD_AREA="flowRuleGoodArea"; //流量策略人工干预商品区
    public static final String FLOW_RULE_FREE_LIMIT = "flowRuleFreeLimit"; //流量策略人工干预活动免费次数开关
    public static final String FLOW_RULE_ADVER_SWITCH = "flowRuleAdverSwitch"; //流量策略广告投放开关
    public static final String FLOW_RULE_FREE_LIMIT_COUNT = "flowRuleFreeLimitCount"; //流量策略人工干预活动免费次数
    public static final String FLOW_RULE_FLOAT_THROW_SWITCH = "flowRuleFloatThrowSwitch"; //流量策略浮标投放策略开关
    public static final String FLOW_RULE_WIN_LUCKY_PROBABILITY_SWITCH = "flowRuleWinLuckyProbabilitySwitch"; //流量策略人工干预福袋中奖概率开关
    public static final String FLOW_RULE_WIN_LUCKY_PROBABILITY = "flowRuleWinLuckyProbability"; //流量策略人工干预福袋中奖概率
    public static final String FLOW_RULE_WIN_LUCKY_PROBABILITY_PLUGINIDS = "flowRuleWinLuckyProbabilityPluginIds"; //流量策略人工干预福袋中奖概率
    public static final String CUSTOMER_SERVICE_ANDROID_SEND_PIC="customerServiceAndroidSendPic";//客服页面安卓发送图片开关
    public static final String CUSTOMER_SERVICE_SHOW_SOURCE="customerServiceShowSource";//客服页面显示客诉来源
    public static final String CUSTOMER_SERVICE_CUSTOMER_SOURCE="customerServiceCustomerSource";//客服页面客诉来源
    public static final String CUSTOMER_SERVICE_CUSTOMER_VIP="customerServiceCustomerVip";//vip客户
    public static final String CUSTOMER_SERVICE_CUSTOMER_TRADE_RECORD="customerServiceCustomerTradeRecord";//是否关闭兑换记录客服
    public static final String CUSTOMER_SERVICE_MIDDLE_PAGE = "customerServiceMiddlePage"; //是否开启客服中间页
    public static final String CUSTOMER_SERVICE_BY_PEOPLE = "customerServiceByPeople";//是否开启人工客服
    public static final String CUSTOMER_SERVICE_SHOW_DEV_SOURCE = "customerServiceShowDevSource";//开发者后台是否显示客诉来源
    public static final String CUSTOMER_SERVICE_DEV_SOURCE = "customerServiceDevSource";//开发者后台客诉来源
    public static final String THANKS_TO_LUCKY_EXCLUDE_ACTIDS = "thxLuckyExcludeActIds";//谢谢参与转福袋例外的活动id列表
    public static final String THANKS_TO_LUCKY_INCLUDE_PLUGINIDS = "thxLuckyIncludePluginIds";//谢谢参与转福袋包含的插件id列表
    public static final String CREATE_SOURCE = "createSource";//app来源，0/null：兑吧，1：推啊
    public static final String DELIVER_OBJECT_ORDER_NOTIFY = "deliverObjectOrderNotify";//实物订单通知接口地址
    public static final String FLOOR_MORE_TASK_SWITCH = "floorMoreTaskSwitch";  //任务楼层更多任务开关
    public static final String FLOOR_MORE_TASK_LINKURL = "floorMoreTaskLinkUrl"; //任务路程更多任务链接url
    public static final String TRADE_BACK_HOME = "tradeBackHome"; //兑换结果页回到首页按钮
    public static final String EARN_CREDITS_LETTER = "earnCreditsLetter"; //获取更多积分按钮文案
    public static final String CREDITS_DETAIL_URL = "creditsDetailUrl"; //积分明细链接
    public static final String REDIRECT_PARAMETER_NAME = "redirectParameterName";  //透传参数
    public static final String APP_COMPANY = "company";//app公司
    public static final String ACCOUNT_SYSTEM = "accountSystem";//账户体系
    public static final String AUDIT_TIMEOUT = "auditTimeout";//售后申请自动审核超时时间
    public static final String CONFIRM_RECEIVE_TIMEOUT = "confirmReceiveTimeout";//确认收货超时时间
    public static final String POST_SALE_TIMEOUT = "postsaleTimeout";//售后完成超时时间

    /**
     * 登陆代码块修改人信息
     */
    public static final String LOGIN_PROGRAM_EDIT_ADMIN_ID = "loginProgramEditAdminId";
    public static final String LOGIN_PROGRAM_EDIT_ADMIN_NAME = "loginProgramEditAdminName";
    public static final String LOGIN_PROGRAM_EDIT_TIME = "loginProgramEditTime";
    /**
     * 分享代码块修改人信息
     */
    public static final String SHARE_PROGRAM_EDIT_ADMIN_ID = "shareProgramEditAdminId";
    public static final String SHARE_PROGRAM_EDIT_ADMIN_NAME = "shareProgramEditAdminName";
    public static final String SHARE_PROGRAM_EDIT_TIME = "shareProgramEditTime";

    /** app全局红包提现开关 */
    public static final String CASH_DRAW_SWITCH = "cashDrawSwitch";
    /** app全局红包提现限制 */
    public static final String CASH_DRAW_LIMIT = "cashDrawLimit";
    /** app全局红包提现限制 */
    public static final String CASH_DRAW_LIMIT_FOR_HAND_REWARD = "cashDrawLimitForHandReward";

    /**
     * app开启经验体系时间
     */
    public static final String OPEN_APP_EXP_TIME = "openAppExpTime";

    /**
     * app是否开启经验体系
     */
    public static final String IS_OPEN_APP_EXP_SWITCH = "isOpenAppExpSwitch";

    public static final String APP_INDUSTRY = "appIndustry";//app行业数据

    /**
     * 开发者应用余额提醒开关
     */
    public static final String APP_BALANCE_REMIND_SWITCH = "appBalanceRemindSwitch";

    /**
     * 开发者应用余额提醒金额阈值
     */
    public static final String APP_BALANCE_REMIND_MONEY = "appBalanceRemindMoney";

    /**
     * 开发者应用余额提醒，最后提醒时间
     */
    public static final String APP_BALANCE_REMIND_LAST_TIME = "appBalanceRemindLastTime";

    /**
     * 开发者应用余额可提现开关
     */
    public static final String APP_BALANCE_CAN_WITHDRAW_SWITCH = "appBalanceCanWithdrawSwitch";

    /**
     * 开发者秒杀配置展示类型
     */
    public static final String APP_SECKILL_SHOW_TYPE = "appSeckillShowType";

    /** 虚拟货币充值接口 */
    public static final String VIRTUAL_MONEY_URL = "virtualMoneyUrl";
    /** 虚拟货币单位 */
    public static final String VIRTUAL_MONEY_UNIT = "virtualMoneyUnit";

    /** 应用支付渠道开关,每位对应支付类型见AppPaychannelEnum */
    public static final String APP_PAY_CHANNEL_SWITCH = "appPayChannelSwitch";

    /** 是否新商品app */
    public static final String APP_NEWGOODS = "newGoods";

    /** 七鱼客服组配置 */
    public static final String QI_YU_VIP = "qiyuVip";

    /**  是否可变现 **/
    public static final String REALIZABLE="realizable";


    /**  完成售后通知接口地址 **/
    public static final String POSTSALE_NOTIFY_URL="postsaleNotifyUrl";

    public static final ImmutableSet<String> propSet;
    static {
        Field[] fields = AppNewExtraDto.class.getDeclaredFields();
        LinkedList pros = new LinkedList();
        for(int i=0; i< fields.length; i++){
            if(Modifier.isStatic(fields[i].getModifiers())){
                continue;
            }
            pros.add(fields[i].getName());
        }
        propSet = ImmutableSet.copyOf(pros);
    }

    private Long appId;
    private String bd;//bd联系人
    private String dailyActLoginUv;//上月日均活动登录UV
    private String onlineDate;//上线日期
    private Boolean flowRule;
    private Integer couponStockWarn;//自有优惠券/虚拟商品库存预警线
    private Integer objectStockWarn;//自有实物库存预警线
    private Boolean notLoginPlayGame;//未登录是否可以参与游戏
    private String secKillValidation; //秒杀验证码类型
    private String exchangeValidation; //普兑验证码类型
    private String consumeVirtualCard;//扣虚拟卡链接
    private String consumeVirtualCardNotify;//扣虚拟卡通知
    private String flowViewTime;//流量策略券展示时间
    private Boolean flowRuleGoodArea;//流量策略人工干预商品区
    private Boolean flowRuleFreeLimit; //流量策略人工干预活动免费次数开关
    private Integer flowRuleFreeLimitCount; //流量策略人工干预活动免费次数
    private Integer flowRuleWinLuckyProbability;//流量策略人工干预福袋中奖概率
    private Boolean flowRuleWinLuckyProbabilitySwitch;//流量策略人工干预福袋中奖概率开关
    private String flowRuleWinLuckyProbabilityPluginIds; //流量策略人工干预福袋中奖概率影响的插件活动ids

    //客服配置-安卓端显示图片
    private Boolean customerServiceAndroidSendPic;
    //客服配置-用户来源是否展示
    private Boolean customerServiceShowSource;
    //客服配置-用户来源
    private String customerServiceCustomerSource;
    //客服配置-是否vip
    private Boolean customerServiceCustomerVip;
    //客服配置-是否关闭兑换记录客服
    private Boolean customerServiceCustomerTradeRecord;
    //是否开启客服中间页
    private Boolean customerServiceMiddlePage;
    //客服配置-开发者后台是否显示客诉来源
    private Boolean customerServiceShowDevSource;
    //客服配置-开发者后台客诉来源
    private String customerServiceDevSource;
    //客服配置-是否直接跳转人工客服
    private Boolean customerServiceByPeople;
    /**
     * 谢谢参与转福袋例外的活动id列表
     */
    private String thxLuckyExcludeActIds;
    private Integer createSource;
    //谢谢参与转福袋的插件ids
    private String thxLuckyIncludePluginIds;

    private Boolean  floorMoreTaskSwitch;
    private String  floorMoreTaskLinkUrl;
    /**
     * 实物订单通知接口地址
     */
    private String deliverObjectOrderNotify;

    private Boolean  tradeBackHome;
    /**
     * 获取更多积分按钮文案
     */
    private String earnCreditsLetter;

    /**
     * 积分明细链接
     */
    private String creditsDetailUrl;

    /**
     * 跳转透传参数名称（默认dbredirect）
     */
    private String redirectParameterName;

    /** app红包提现开关 */
    private Boolean cashDrawSwitch;
    /** app全局红包提现限制 */
    private String cashDrawLimit;
    /**
     * 浮标地域策略开关
     */
    private Boolean flowRuleFloatThrowSwitch;

    /**
     * 广告投放开关
     */
    private Boolean flowRuleAdverSwitch;

    /**
     * app开始经验体系时间
     */
    private String openAppExpTime;

    /**
     * app是否开启经验体系开关  on开启  off关闭
     */
    private String isOpenAppExpSwitch;

    private String appIndustry; //app行业

    /**
     * 登陆代码块最后修改人员信息（adminId,adminName,editTime）
     */
    private String loginProgramEditAdminId;
    private String loginProgramEditAdminName;
    private String loginProgramEditTime;

    /**
     * 分享代码块最后修改人员信息（adminId,adminName,editTime）
     */
    private String shareProgramEditAdminId;
    private String shareProgramEditAdminName;
    private String shareProgramEditTime;
    private String company;
    private String accountSystem;

    /**
     * app余额提醒
     */
    private Boolean appBalanceRemindSwitch;
    private Long appBalanceRemindMoney;
    private String appBalanceRemindLastTime;

    /**
     * 开发者应用余额账户可提现开关
     */
    private Boolean appBalanceCanWithdrawSwitch;

    /** 虚拟货币充值接口 */
    private String virtualMoneyUrl;
    /** 虚拟货币单位 */
    private String virtualMoneyUnit;
    //应用支付渠道开关,每位对应支付类型见AppPaychannelEnum
    private Long  appPayChannelSwitch;
    //是否新商品版本
    private Boolean newGoods;
    // 客服组配置
    private Integer qiyuVip;

    /** app手气红包提现限制 */
    private String cashDrawLimitForHandReward;

    //可否变现开关
    private Boolean realizable;


    //完成售后通知接口地址
    private String postsaleNotifyUrl;

    private String auditTimeout;

    private String confirmReceiveTimeout;

    private String postSaleTimeout;

    public String getPostsaleNotifyUrl() {
        return postsaleNotifyUrl;
    }

    public void setPostsaleNotifyUrl(String postsaleNotifyUrl) {
        this.postsaleNotifyUrl = postsaleNotifyUrl;
    }

    public Boolean getRealizable() {
        return realizable;
    }

    public void setRealizable(Boolean realizable) {
        this.realizable = realizable;
    }

    public Integer getQiyuVip() {
        return qiyuVip;
    }

    public void setQiyuVip(Integer qiyuVip) {
        this.qiyuVip = qiyuVip;
    }

    public String getVirtualMoneyUrl() {
        return virtualMoneyUrl;
    }

    public void setVirtualMoneyUrl(String virtualMoneyUrl) {
        this.virtualMoneyUrl = virtualMoneyUrl;
    }

    public String getVirtualMoneyUnit() {
        return virtualMoneyUnit;
    }

    public void setVirtualMoneyUnit(String virtualMoneyUnit) {
        this.virtualMoneyUnit = virtualMoneyUnit;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getLoginProgramEditAdminId() {
        return loginProgramEditAdminId;
    }

    public void setLoginProgramEditAdminId(String loginProgramEditAdminId) {
        this.loginProgramEditAdminId = loginProgramEditAdminId;
    }

    public String getLoginProgramEditAdminName() {
        return loginProgramEditAdminName;
    }

    public void setLoginProgramEditAdminName(String loginProgramEditAdminName) {
        this.loginProgramEditAdminName = loginProgramEditAdminName;
    }

    public String getShareProgramEditAdminId() {
        return shareProgramEditAdminId;
    }

    public void setShareProgramEditAdminId(String shareProgramEditAdminId) {
        this.shareProgramEditAdminId = shareProgramEditAdminId;
    }

    public String getShareProgramEditAdminName() {
        return shareProgramEditAdminName;
    }

    public void setShareProgramEditAdminName(String shareProgramEditAdminName) {
        this.shareProgramEditAdminName = shareProgramEditAdminName;
    }

    public String getLoginProgramEditTime() {
        return loginProgramEditTime;
    }

    public void setLoginProgramEditTime(String loginProgramEditTime) {
        this.loginProgramEditTime = loginProgramEditTime;
    }

    public String getShareProgramEditTime() {
        return shareProgramEditTime;
    }

    public void setShareProgramEditTime(String shareProgramEditTime) {
        this.shareProgramEditTime = shareProgramEditTime;
    }

    public Boolean getFlowRuleFloatThrowSwitch() {
        return flowRuleFloatThrowSwitch;
    }

    public void setFlowRuleFloatThrowSwitch(Boolean flowRuleFloatThrowSwitch) {
        this.flowRuleFloatThrowSwitch = flowRuleFloatThrowSwitch;
    }

    public String getCashDrawLimitForHandReward() {
        return cashDrawLimitForHandReward;
    }

    public void setCashDrawLimitForHandReward(String cashDrawLimitForHandReward) {
        this.cashDrawLimitForHandReward = cashDrawLimitForHandReward;
    }

    public String getDeliverObjectOrderNotify() {
        return deliverObjectOrderNotify;
    }

    public void setDeliverObjectOrderNotify(String deliverObjectOrderNotify) {
        this.deliverObjectOrderNotify = deliverObjectOrderNotify;
    }

    public Boolean getCustomerServiceShowDevSource() {
        return customerServiceShowDevSource;
    }

    public void setCustomerServiceShowDevSource(Boolean customerServiceShowDevSource) {
        this.customerServiceShowDevSource = customerServiceShowDevSource;
    }

    public String getCustomerServiceDevSource() {
        return customerServiceDevSource;
    }

    public void setCustomerServiceDevSource(String customerServiceDevSource) {
        this.customerServiceDevSource = customerServiceDevSource;
    }

    public String getSecKillValidation() {
        return secKillValidation;
    }

    public void setSecKillValidation(String secKillValidation) {
        this.secKillValidation = secKillValidation;
    }

    public String getExchangeValidation() {
        return exchangeValidation;
    }

    public void setExchangeValidation(String exchangeValidation) {
        this.exchangeValidation = exchangeValidation;
    }

    public Long getAppId() {
        return appId;
    }
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    public String getBd() {
        return bd;
    }
    public void setBd(String bd) {
        this.bd = bd;
    }
    public String getDailyActLoginUv() {
        return dailyActLoginUv;
    }
    public void setDailyActLoginUv(String dailyActLoginUv) {
        this.dailyActLoginUv = dailyActLoginUv;
    }
    public String getOnlineDate() {
        return onlineDate;
    }
    public void setOnlineDate(String onlineDate) {
        this.onlineDate = onlineDate;
    }

    public Boolean getFlowRule() {
        return flowRule;
    }

    public void setFlowRule(Boolean flowRule) {
        this.flowRule = flowRule;
    }
    public Integer getCouponStockWarn() {
        return couponStockWarn;
    }
    public void setCouponStockWarn(Integer couponStockWarn) {
        this.couponStockWarn = couponStockWarn;
    }
    public Integer getObjectStockWarn() {
        return objectStockWarn;
    }
    public void setObjectStockWarn(Integer objectStockWarn) {
        this.objectStockWarn = objectStockWarn;
    }

    public Boolean getNotLoginPlayGame() {
        return notLoginPlayGame;
    }

    public void setNotLoginPlayGame(Boolean notLoginPlayGame) {
        this.notLoginPlayGame = notLoginPlayGame;
    }

    public String getConsumeVirtualCard() {
        return consumeVirtualCard;
    }

    public void setConsumeVirtualCard(String consumeVirtualCard) {
        this.consumeVirtualCard = consumeVirtualCard;
    }

    public String getConsumeVirtualCardNotify() {
        return consumeVirtualCardNotify;
    }

    public void setConsumeVirtualCardNotify(String consumeVirtualCardNotify) {
        this.consumeVirtualCardNotify = consumeVirtualCardNotify;
    }

    public String getFlowViewTime() {
        return flowViewTime;
    }

    public void setFlowViewTime(String flowViewTime) {
        this.flowViewTime = flowViewTime;
    }

    public String getThxLuckyExcludeActIds() {
        return thxLuckyExcludeActIds;
    }

    public void setThxLuckyExcludeActIds(String thxLuckyExcludeActIds) {
        this.thxLuckyExcludeActIds = thxLuckyExcludeActIds;
    }

    public Boolean getFlowRuleGoodArea() {
        return flowRuleGoodArea;
    }

    public void setFlowRuleGoodArea(Boolean flowRuleGoodArea) {
        this.flowRuleGoodArea = flowRuleGoodArea;
    }

    public Boolean getCustomerServiceAndroidSendPic() {
        return customerServiceAndroidSendPic;
    }

    public void setCustomerServiceAndroidSendPic(Boolean customerServiceAndroidSendPic) {
        this.customerServiceAndroidSendPic = customerServiceAndroidSendPic;
    }

    public Boolean getCustomerServiceShowSource() {
        return customerServiceShowSource;
    }

    public void setCustomerServiceShowSource(Boolean customerServiceShowSource) {
        this.customerServiceShowSource = customerServiceShowSource;
    }

    public String getCustomerServiceCustomerSource() {
        return customerServiceCustomerSource;
    }

    public void setCustomerServiceCustomerSource(String customerServiceCustomerSource) {
        this.customerServiceCustomerSource = customerServiceCustomerSource;
    }

    public Boolean getFlowRuleFreeLimit() {
        return flowRuleFreeLimit;
    }

    public void setFlowRuleFreeLimit(Boolean flowRuleFreeLimit) {
        this.flowRuleFreeLimit = flowRuleFreeLimit;
    }

    public Integer getFlowRuleFreeLimitCount() {
        return flowRuleFreeLimitCount;
    }

    public void setFlowRuleFreeLimitCount(Integer flowRuleFreeLimitCount) {
        this.flowRuleFreeLimitCount = flowRuleFreeLimitCount;
    }

    public Integer getCreateSource() {
        return createSource;
    }

    public void setCreateSource(Integer createSource) {
        this.createSource = createSource;
    }

    public String getThxLuckyIncludePluginIds() {
        return thxLuckyIncludePluginIds;
    }

    public void setThxLuckyIncludePluginIds(String thxLuckyIncludePluginIds) {
        this.thxLuckyIncludePluginIds = thxLuckyIncludePluginIds;
    }

    public Integer getFlowRuleWinLuckyProbability() {
        return flowRuleWinLuckyProbability;
    }

    public void setFlowRuleWinLuckyProbability(Integer flowRuleWinLuckyProbability) {
        this.flowRuleWinLuckyProbability = flowRuleWinLuckyProbability;
    }

    public Boolean getFlowRuleWinLuckyProbabilitySwitch() {
        return flowRuleWinLuckyProbabilitySwitch;
    }

    public void setFlowRuleWinLuckyProbabilitySwitch(Boolean flowRuleWinLuckyProbabilitySwitch) {
        this.flowRuleWinLuckyProbabilitySwitch = flowRuleWinLuckyProbabilitySwitch;
    }

    public Boolean getFloorMoreTaskSwitch() {
        return floorMoreTaskSwitch;
    }

    public void setFloorMoreTaskSwitch(Boolean floorMoreTaskSwitch) {
        this.floorMoreTaskSwitch = floorMoreTaskSwitch;
    }

    public String getFloorMoreTaskLinkUrl() {
        return floorMoreTaskLinkUrl;
    }

    public void setFloorMoreTaskLinkUrl(String floorMoreTaskLinkUrl) {
        this.floorMoreTaskLinkUrl = floorMoreTaskLinkUrl;
    }

    public Boolean getCustomerServiceCustomerVip() {
        return customerServiceCustomerVip;
    }

    public void setCustomerServiceCustomerVip(Boolean customerServiceCustomerVip) {
        this.customerServiceCustomerVip = customerServiceCustomerVip;
    }
    public String getFlowRuleWinLuckyProbabilityPluginIds() {
        return flowRuleWinLuckyProbabilityPluginIds;
    }

    public void setFlowRuleWinLuckyProbabilityPluginIds(String flowRuleWinLuckyProbabilityPluginIds) {
        this.flowRuleWinLuckyProbabilityPluginIds = flowRuleWinLuckyProbabilityPluginIds;
    }

    public Boolean getCustomerServiceCustomerTradeRecord() {
        return customerServiceCustomerTradeRecord;
    }

    public void setCustomerServiceCustomerTradeRecord(Boolean customerServiceCustomerTradeRecord) {
        this.customerServiceCustomerTradeRecord = customerServiceCustomerTradeRecord;
    }

    public Boolean getTradeBackHome() {
        return tradeBackHome;
    }

    public void setTradeBackHome(Boolean tradeBackHome) {
        this.tradeBackHome = tradeBackHome;
    }

    public String getEarnCreditsLetter() {
        return earnCreditsLetter;
    }

    public void setEarnCreditsLetter(String earnCreditsLetter) {
        this.earnCreditsLetter = earnCreditsLetter;
    }

    public String getCreditsDetailUrl() {
        return creditsDetailUrl;
    }

    public void setCreditsDetailUrl(String creditsDetailUrl) {
        this.creditsDetailUrl = creditsDetailUrl;
    }

    public String getRedirectParameterName() {
        return redirectParameterName;
    }

    public void setRedirectParameterName(String redirectParameterName) {
        this.redirectParameterName = redirectParameterName;
    }

    public Boolean getCashDrawSwitch() {
        return cashDrawSwitch;
    }

    public void setCashDrawSwitch(Boolean cashDrawSwitch) {
        this.cashDrawSwitch = cashDrawSwitch;
    }

    public String getCashDrawLimit() {
        return cashDrawLimit;
    }

    public void setCashDrawLimit(String cashDrawLimit) {
        this.cashDrawLimit = cashDrawLimit;
    }

    public Boolean getCustomerServiceMiddlePage() {
        return customerServiceMiddlePage;
    }

    public void setCustomerServiceMiddlePage(Boolean customerServiceMiddlePage) {
        this.customerServiceMiddlePage = customerServiceMiddlePage;
    }

    public String getOpenAppExpTime() {
        return openAppExpTime;
    }

    public void setOpenAppExpTime(String openAppExpTime) {
        this.openAppExpTime = openAppExpTime;
    }

    public String getIsOpenAppExpSwitch() {
        return isOpenAppExpSwitch;
    }

    public void setIsOpenAppExpSwitch(String isOpenAppExpSwitch) {
        this.isOpenAppExpSwitch = isOpenAppExpSwitch;
    }

    public String getAppIndustry() { return appIndustry; }

    public void setAppIndustry(String appIndustry) { this.appIndustry = appIndustry; }

    public Boolean getFlowRuleAdverSwitch() {
        return flowRuleAdverSwitch;
    }

    public void setFlowRuleAdverSwitch(Boolean flowRuleAdverSwitch) {
        this.flowRuleAdverSwitch = flowRuleAdverSwitch;
    }

    public String getAccountSystem() {
        return accountSystem;
    }

    public void setAccountSystem(String accountSystem) {
        this.accountSystem = accountSystem;
    }

    public Boolean getAppBalanceRemindSwitch() {
        return appBalanceRemindSwitch;
    }

    public void setAppBalanceRemindSwitch(Boolean appBalanceRemindSwitch) {
        this.appBalanceRemindSwitch = appBalanceRemindSwitch;
    }

    public Long getAppBalanceRemindMoney() {
        return appBalanceRemindMoney;
    }

    public void setAppBalanceRemindMoney(Long appBalanceRemindMoney) {
        this.appBalanceRemindMoney = appBalanceRemindMoney;
    }

    public String getAppBalanceRemindLastTime() {
        return appBalanceRemindLastTime;
    }

    public void setAppBalanceRemindLastTime(String appBalanceRemindLastTime) {
        this.appBalanceRemindLastTime = appBalanceRemindLastTime;
    }

    public Boolean getAppBalanceCanWithdrawSwitch() {
        return appBalanceCanWithdrawSwitch;
    }

    public void setAppBalanceCanWithdrawSwitch(Boolean appBalanceCanWithdrawSwitch) {
        this.appBalanceCanWithdrawSwitch = appBalanceCanWithdrawSwitch;
    }

    public Long getAppPayChannelSwitch() {
        return appPayChannelSwitch;
    }

    public void setAppPayChannelSwitch(Long appPayChannelSwitch) {
        this.appPayChannelSwitch = appPayChannelSwitch;
    }

    public Boolean getNewGoods() {
        return newGoods;
    }

    public void setNewGoods(Boolean newGoods) {
        this.newGoods = newGoods;
    }

    public Boolean getCustomerServiceByPeople() {
        return customerServiceByPeople;
    }

    public void setCustomerServiceByPeople(Boolean customerServiceByPeople) {
        this.customerServiceByPeople = customerServiceByPeople;
    }

    public String getAuditTimeout() {
        return auditTimeout;
    }

    public void setAuditTimeout(String auditTimeout) {
        this.auditTimeout = auditTimeout;
    }

    public String getConfirmReceiveTimeout() {
        return confirmReceiveTimeout;
    }

    public void setConfirmReceiveTimeout(String confirmReceiveTimeout) {
        this.confirmReceiveTimeout = confirmReceiveTimeout;
    }

    public String getPostSaleTimeout() {
        return postSaleTimeout;
    }

    public void setPostSaleTimeout(String postSaleTimeout) {
        this.postSaleTimeout = postSaleTimeout;
    }
}
