package cn.com.duiba.developer.center.api.domain.dto.app;

import cn.com.duiba.developer.center.api.domain.enums.BasicSetting.AppEnvJudgeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author JunAngLiu
 * @Title: AppExtraLargeFieldDto
 * @Description: app 分享代码
 * @date 2018/12/2719:54
 */
public class AppExtraLargeFieldDto implements Serializable {//NOSONAR

    private static final long serialVersionUID = -3399578652734777984L;

    public static final int SwitchDevShareIos = 1; //ios分享开关
    public static final int SwitchDevShareAndroid = 2; // android分享开关
    public static final int SwitchDevCallUp = 3;//唤起登陆开关
    public static final int SwitchDevCallUpRegistH5 = 4; // 唤起登录注册h5开关
    public static final int SwitchAppEnvJudge = 5;//app环境判断开关

    public static final int SwitchAppItemRedirect = 6;//app 商品详情跳转开关

    private Long id;
    /**
     * appId
     */
    private Long appId;

    /**
     * 开关
     */
    private Long shareSwitch;

    /**
     * ios 分享代码
     */
    private String shareIosCode;

    /**
     * android 分享代码
     */
    private String shareAndroidCode;
    /**
     * 唤起登录代码
     */
    private String callUpCode;
    /**
     * 唤起登录注册h5代码
     */
    private String callUpRegistH5Code;

    /**
     * app环境判断方式
     * 1，通过ua标识判断
     * 2，通过特定方法判断
     */
    private AppEnvJudgeEnum anEnum;

    /**
     * ua环境判断标识
     */
    private String uaIdentification;
    /**
     * ios判断方法
     */
    private String iosJudgeMethod;
    /**
     * android判断方法
     */
    private String androidJudgeMethod;

    /**
     * 商品详情页配置页
     */
    private String itemShareConfig;

    /**
     * 唤端类型:0 兑吧唤端页，1 开发者唤端页
     */
    private Integer callUpType;
    /**
     * (新)开发者唤端页路径
     */
    private String developerCustomCallUpPage;
    /**
     * ios唤端链接
     */
    private String iosDeepLink;
    /**
     * android唤端链接
     */
    private String androidDeepLink;

    /**
     * 关注公众号二维码
     */
    private String wechatQrcode;
    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public boolean isShareSwitch(int boundType) {
        long v = 1 << boundType;
        long ret = shareSwitch & v;
        return ret != 0;
    }


    public Long getShareSwitch() {
        return shareSwitch;
    }

    public void setShareSwitch(Long shareSwitch) {
        this.shareSwitch = shareSwitch;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getShareIosCode() {
        return shareIosCode;
    }

    public void setShareIosCode(String shareIosCode) {
        this.shareIosCode = shareIosCode;
    }

    public String getShareAndroidCode() {
        return shareAndroidCode;
    }

    public void setShareAndroidCode(String shareAndroidCode) {
        this.shareAndroidCode = shareAndroidCode;
    }

    public String getCallUpCode() {
        return callUpCode;
    }

    public void setCallUpCode(String callUpCode) {
        this.callUpCode = callUpCode;
    }

    public String getCallUpRegistH5Code() {
        return callUpRegistH5Code;
    }

    public void setCallUpRegistH5Code(String callUpRegistH5Code) {
        this.callUpRegistH5Code = callUpRegistH5Code;
    }

    public AppEnvJudgeEnum getAnEnum() {
        return anEnum;
    }

    public void setAnEnum(AppEnvJudgeEnum anEnum) {
        this.anEnum = anEnum;
    }

    public String getUaIdentification() {
        return uaIdentification;
    }

    public void setUaIdentification(String uaIdentification) {
        this.uaIdentification = uaIdentification;
    }

    public String getIosJudgeMethod() {
        return iosJudgeMethod;
    }

    public void setIosJudgeMethod(String iosJudgeMethod) {
        this.iosJudgeMethod = iosJudgeMethod;
    }

    public String getAndroidJudgeMethod() {
        return androidJudgeMethod;
    }

    public void setAndroidJudgeMethod(String androidJudgeMethod) {
        this.androidJudgeMethod = androidJudgeMethod;
    }

    public String getItemShareConfig() {
        return itemShareConfig;
    }

    public void setItemShareConfig(String itemShareConfig) {
        this.itemShareConfig = itemShareConfig;
    }

    public Integer getCallUpType() {
        return callUpType;
    }

    public void setCallUpType(Integer callUpType) {
        this.callUpType = callUpType;
    }

    public String getDeveloperCustomCallUpPage() {
        return developerCustomCallUpPage;
    }

    public void setDeveloperCustomCallUpPage(String developerCustomCallUpPage) {
        this.developerCustomCallUpPage = developerCustomCallUpPage;
    }

    public String getIosDeepLink() {
        return iosDeepLink;
    }

    public void setIosDeepLink(String iosDeepLink) {
        this.iosDeepLink = iosDeepLink;
    }

    public String getAndroidDeepLink() {
        return androidDeepLink;
    }

    public void setAndroidDeepLink(String androidDeepLink) {
        this.androidDeepLink = androidDeepLink;
    }

    public String getWechatQrcode() {
        return wechatQrcode;
    }

    public void setWechatQrcode(String wechatQrcode) {
        this.wechatQrcode = wechatQrcode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
