package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.url.DomainAppDto;
import cn.com.duiba.developer.center.api.domain.dto.url.DomainGroupDto;
import cn.com.duiba.developer.center.api.domain.dto.url.NewDomainReductionDto;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.DomainGroupQueryParams;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainService {

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Deprecated
    List<DomainGroupDto> findDomainGroups(Integer pageNum, Integer pageSize);

    /**
     * 查询列表
     * @param queryParams 查询参数
     * @return
     */
    Page<DomainGroupDto> getDomainGroupsPage(DomainGroupQueryParams queryParams);

    Long getDomainGroupCount();

    /**
     * 查询分组内app
     * @param groupId
     * @return
     */
    List<DomainAppDto> findAppByGroupIds(Long groupId);

    /**
     * 新增域名组
     * @param domainGroupDto
     * @return
     */
    boolean insertGroup(DomainGroupDto domainGroupDto);

    /**
     * 更新域名组
     * @param domainGroupDto
     * @return
     */
    boolean updateGroup(DomainGroupDto domainGroupDto);

    /**
     * 删除域名组
     * @param groupId
     * @return
     */
    boolean deleteGroup(Long groupId);

    /**
     * 分组新增app
     * @param groupId
     * @param appIds
     * @return
     */
    boolean saveOrUpdateApp(Long groupId,List<Long> appIds);

    /**
     * 删除app
     * @param groupId
     * @param appIds
     * @return
     */
    boolean deleteApp(Long groupId,List<Long> appIds);

    /**
     * 一键切换
     * @param groupId
     * @param appIds
     * @return
     */
    boolean switchDomain(Long groupId, List<Long> appIds) throws BizException;

}
