package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by liuyao on 16/7/29.
 */
public class AppLayoutDto implements Serializable {//NOSONAR

    private static final long     serialVersionUID     = 5563360378164302732L;

    public static final short     Skin_Type_Old_Theme  = 0;                   // 老皮肤
    public static final short     Skin_Type_Floor_Skin = 1;                   // 新楼层皮肤

    private Long                  id;
    private Long                  appId;
    private String                themeColor;
    private JSONArray             developSortJson = new JSONArray();                            // 开发者楼层排序json。
    private Map<Long, JSONObject> developDataShowJson = Collections.emptyMap();                        // 开发者数据修改json
    private Short                 skinType;
    private Long                  skinId;

    // 从AppLayoutBrick 取出来的字段d
    private Long                  brickId;                                    // 使用老皮肤的Id
    private String                brickMd5;                                   // 使用老皮肤的MD5
    private Integer               imageStyle;                                 // 使用老皮肤对应的缩略图类型
    private String brickIds;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getBrickId() {
        return brickId;
    }

    public void setBrickId(Long brickId) {
        this.brickId = brickId;
    }

    public String getThemeColor() {
        return themeColor;
    }

    public void setThemeColor(String themeColor) {
        this.themeColor = themeColor;
    }

    public String getBrickMd5() {
        return brickMd5;
    }

    public void setBrickMd5(String brickMd5) {
        this.brickMd5 = brickMd5;
    }

    public Integer getImageStyle() {
        return imageStyle;
    }

    public void setImageStyle(Integer imageStyle) {
        this.imageStyle = imageStyle;
    }

    public Short getSkinType() {
        return skinType;
    }

    public void setSkinType(Short skinType) {
        this.skinType = skinType;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    /**
     * @return [{id:楼层Id,floorType:楼层类型,enable:是否展示}]
     */
    public JSONArray getDevelopSortJson() {
        return developSortJson;
    }

    public void setDevelopSortJson(JSONArray developSortJson) {
        this.developSortJson = developSortJson;
    }

    public Map<Long, JSONObject> getDevelopDataShowJson() {
        return developDataShowJson;
    }

    public void setDevelopDataShowJson(Map<Long, JSONObject> developDataShowJson) {
        this.developDataShowJson = developDataShowJson;
    }

    public String getBrickIds() {
        return brickIds;
    }

    public void setBrickIds(String brickIds) {
        this.brickIds = brickIds;
    }
}
