package cn.com.duiba.developer.center.api.domain.dto.survey;

import cn.com.duiba.developer.center.api.domain.enums.survey.QuestionTypeEnum;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 问题
 */
public class QuestionDto implements Serializable {
    private static final long serialVersionUID = -1417072652463885354L;
    /**
     * ID
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 问券Id
     */
    private Long surveyId;
    /**
     * 问券版本
     */
    private Integer version;

    /**
     * 编码，统一问券下唯一，前端生成
     */
    @Size(max = 50, message = "问题编码长度不正确")
    @NotNull(message = "问题编码必填")
    private String code;
    /**
     * 题目类型
     * {@link QuestionTypeEnum}
     */
    @NotNull
    private String type;
    /**
     * 题目
     */
    @Size(max = 50, message = "题目标题过长")
    @NotNull(message = "题目标题不能为空")
    private String title;
    /**
     * 备注
     */
    @Size(max = 20, message = "description过长")
    private String description;
    /**
     * 是否必填
     */
    private Boolean required = true;

    /**
     * 校验
     * mobile
     */
    private String validate;

    /**
     * 问题可以没有选项
     */
    @Size(max = 15, message = "每个选项最多15个")
    private List<OptionDto> options;


    private String jump;

    private String display;

    /**
     * 用户答案，其他选项用
     */
    private List<AnswerContent> contentList;

    /**
     * 题目是否展示给用户
     */
    private Boolean show;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getSurveyId() {
        return surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getValidate() {
        return validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public List<OptionDto> getOptions() {
        return options;
    }

    public void setOptions(List<OptionDto> options) {
        this.options = options;
    }

    public List<AnswerContent> getContentList() {
        return contentList;
    }

    public void setContentList(List<AnswerContent> contentList) {
        this.contentList = contentList;
    }

    public String getJump() {
        return jump;
    }

    public void setJump(String jump) {
        this.jump = jump;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Boolean getShow() {
        return show;
    }

    public void setShow(Boolean show) {
        this.show = show;
    }

}
