

package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

/**
订购模块
 */
public enum PurchaseModuleEnum {
    CORE_OPERATE(1L, "核心效果运营"),
    HDTOOL(2L, "活动工具"),
    CUSTOMIZE(3L, "商城自定义搭建"),
    MARKETING(4L, "营销工具"),
    EQUITY(5L, "权益核销体系"),
    CARD(6L, "卡券库"),
    PURCHASE(7L, "商品采购接口"),
    MALL_PROXY(8L, "积分商城代运营服务"),
    ADVISORY(9L, "运营咨询服务费"),
    SUPPLY_ACT(10L, "补给站活动"),
    SKIN(11L, "活动工具皮肤"),
    HDTOOL_PROXY(12L, "全年活动工具代运营"),
    CHECK_OUT_ACCOUNT(13L, "收银台功能定制"),
    GIVE_CREDITS(14L, "积分发放系统"),
    ;

    /** 代码 */
    private Long code;

    /** 描述 */
    private String desc;

     PurchaseModuleEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static PurchaseModuleEnum getByCode(Long code) {
        for (PurchaseModuleEnum enumVal : PurchaseModuleEnum.values()) {
            if (Objects.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
