package cn.com.duiba.developer.center.api.remoteservice.customerService;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.customService.QuestionCategoryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteQuestionCategoryService {
    List<QuestionCategoryDto> findAllCategoryByAppId(Long appId);

    List<QuestionCategoryDto> findByAppIdWithCategory(Long appId, Integer categoryType, boolean includedQuestion);

    void batchSaveUpdateList(Long appId, List<QuestionCategoryDto> questionCategoryDtoList, List<Long> needRemovedList) throws BizException;

    void batchDeleteByIdList(Long appId, List<Long> needRemovedList) throws BizException;

    List<QuestionCategoryDto> findByIdList(List<Long> idList);
}