package cn.com.duiba.developer.center.api.remoteservice.purchase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.purchase.PurchaseAdvConfigDTO;
import cn.com.duiba.developer.center.api.domain.dto.purchase.PurchaseAdvDetailDTO;
import cn.com.duiba.developer.center.api.domain.param.PurchaseAdvDetailParam;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

import java.util.List;

/**
 * @Date 2022/4/13 4:27 下午
 * @Created by cmm
 */
@AdvancedFeignClient
public interface RemotePurchaseAdvDetailService {
    void save(PurchaseAdvDetailDTO dto);

    void update(PurchaseAdvDetailDTO dto);

    void delete(Long id);

    PurchaseAdvDetailDTO getById(Long id);

    Boolean checkTitleUnique(PurchaseAdvDetailParam param);

    PaginationVO<PurchaseAdvDetailDTO> selectPageList(PurchaseAdvDetailParam param);

    List<PurchaseAdvDetailDTO> getFrontPageList();
}
