package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @date:2021/11/22 18:11
 * @author:zhaozhanghai
 * @Description: 替换cdn域名
 */
public class ReplaceCdnUtil {

   private static String regex="//(yun|yun-)([0-9]{0,1}).duiba.com.cn";

    /**
     * 替换cdn
     * @param domainConfigDto  域名配置
     * @param url 需要替换的url
     * @return
     */
    public static String replaceCdn(DomainConfigDto domainConfigDto, String url){
        if (Objects.isNull(domainConfigDto)){
            return url;
        }

        return  replaceCdn(domainConfigDto.getCdnDomain(),url);


    }

    public static  String replaceCdn(String cdnDomain, String url) {

        if (StringUtils.isNotEmpty(url) && StringUtils.isNotEmpty(cdnDomain)){
           url=url.replaceAll(regex,cdnDomain);

        }
        return url;
    }
}
