package cn.com.duiba.developer.center.api.domain.param.platform;

import cn.com.duiba.developer.center.api.domain.enums.authority.RightBusinessSubTagEnum;
import cn.com.duiba.developer.center.api.domain.enums.authority.RightBusinessTagEnum;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2022/12/6 14
 * @Description:
 */
public class SyncActivityParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 一级类目
     * @see RightBusinessTagEnum
     */
    @NotNull(message = "rightBusinessTagCode必填")
    private Integer rightBusinessTagCode;

    /**
     * 二级子类目
     * 预留字段，本次用不到
     * @see RightBusinessSubTagEnum
     */
    private Integer rightBusinessSubTagCode;

    /**
     * 活动模版名称
     */
    @NotNull(message = "activityTemplateName必填")
    private String activityTemplateName;

    public Integer getRightBusinessTagCode() {
        return rightBusinessTagCode;
    }

    public void setRightBusinessTagCode(Integer rightBusinessTagCode) {
        this.rightBusinessTagCode = rightBusinessTagCode;
    }

    public Integer getRightBusinessSubTagCode() {
        return rightBusinessSubTagCode;
    }

    public void setRightBusinessSubTagCode(Integer rightBusinessSubTagCode) {
        this.rightBusinessSubTagCode = rightBusinessSubTagCode;
    }

    public String getActivityTemplateName() {
        return activityTemplateName;
    }

    public void setActivityTemplateName(String activityTemplateName) {
        this.activityTemplateName = activityTemplateName;
    }
}
