/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.InternalLetterBo;
import cn.com.duiba.developer.center.biz.runnble.InternalLetterTask;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterKeyService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterService;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InternalLetterBoImpl
implements InternalLetterBo,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(InternalLetterBoImpl.class);
    private ApplicationContext applicationContext;
    private Splitter spl = Splitter.on((String)",").trimResults().omitEmptyStrings();
    @Autowired
    private InternalLetterService internalLetterService;
    @Autowired
    private InternalLetterKeyService internalLetterKeyService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;
    private ScheduledExecutorService timeService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    private void init() {
        this.timeService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Long> ids = InternalLetterBoImpl.this.internalLetterService.findAllCanPushIds();
                    if (ids.isEmpty()) {
                        return;
                    }
                    Iterator<Long> it = ids.iterator();
                    while (it.hasNext()) {
                        InternalLetterBoImpl.this.pushTask(it.next());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u7ed4\u6b0f\u5534\u6dc7\u2103\u58c2\u93bb\u5fd3\u3051\u7490\ufffd", (Throwable)e);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    @Transactional(value="manager")
    public void submitInternalLetter(Optional<InternalLetterDO> letter) throws BusinessException {
        InternalLetterDO letterDO = (InternalLetterDO)letter.get();
        if (Objects.equal((Object)1, (Object)letterDO.getSendWay())) {
            if (Objects.equal(null, (Object)letterDO.getSendTime())) {
                throw new BusinessException("\u7039\u6c2d\u6902\u9359\u6226\ufffd\u4f78\u7e40\u6924\u7ed8\u5bda\u7039\u6c2c\u5f42\u95ab\u4f79\u6902\u95c2\ufffd");
            }
            if (new Date().after(letterDO.getSendTime())) {
                throw new BusinessException("\u7039\u6c2d\u6902\u93c3\u5815\u68ff\u8e47\u5474\u300f\u6fb6\u0442\u7c2c\u8930\u64b3\u58a0\u93c3\u5815\u68ff");
            }
        } else {
            letterDO.setSendTime(new Date());
        }
        if (Objects.equal(null, (Object)letterDO.getId())) {
            this.internalLetterService.insert(letterDO);
        } else {
            InternalLetterDO old = this.internalLetterService.findForUpdate(letterDO.getId());
            if (Objects.equal(null, (Object)old) || old.getDeleted().booleanValue()) {
                throw new BusinessException("\u7487\u30e7\u73ef\u9350\u546c\u4fca\u5bb8\u832c\u7ca1\u6d93\u5d85\u74e8\u9366\ufffd");
            }
            if (1 == old.getSendStatue()) {
                throw new BusinessException("\u5bb8\u832c\u7ca1\u9359\u6226\ufffd\u4f7a\u6b91\u7ed4\u6b0f\u5534\u6dc7\u2032\u7b09\u9359\ue21c\u7d2a\u6748\ufffd");
            }
            this.internalLetterService.update(letterDO);
        }
        if (Objects.equal((Object)0, (Object)letterDO.getSendWay())) {
            this.pushTask(letterDO.getId());
        }
    }

    @Override
    @Transactional(value="manager")
    public void deleteInternalLette(Long letterId) throws BusinessException {
        InternalLetterDO letter = this.internalLetterService.findForUpdate(letterId);
        if (Objects.equal(null, (Object)letter)) {
            throw new BusinessException("\u93b5\ufffd\u7455\u4f78\u57b9\u95c4\u3087\u6b91\u7ed4\u6b0f\u5534\u6dc7\u2032\u7b09\u701b\u6a3a\u6e6a");
        }
        this.internalLetterService.delete(letter);
        if (Objects.equal((Object)1, (Object)letter.getSendStatue())) {
            this.internalLetterKeyService.batchDelete(letter.getId());
        }
    }

    @Override
    public void deleteInternalLette(Long developerId, Long letterId) throws BusinessException {
        this.internalLetterKeyService.deleteOne(letterId, developerId);
    }

    @Override
    public PaginationVO<InternalLetterDO> getInternalLetterPage(InternalLetterQueryEntity param) {
        List<InternalLetterDO> list = this.internalLetterService.findListPage((PageQueryEntity)param);
        Long count = this.internalLetterService.findCountPage((PageQueryEntity)param);
        PaginationVO page = new PaginationVO();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public PaginationVO<InternalLetterKeyDO> getInternalLetterKeyPage(InternalLetterQueryEntity param) {
        List<InternalLetterKeyDO> list = this.internalLetterKeyService.findPage((PageQueryEntity)param);
        Long count = this.internalLetterKeyService.findPageCount((PageQueryEntity)param);
        PaginationVO page = new PaginationVO();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public int setAllReaded(Long developerId) {
        return this.internalLetterKeyService.updateAllReaded(developerId);
    }

    @Override
    public InternalLetterDO developerFindInternalLetter(Long developerId, Long letterId) {
        this.internalLetterKeyService.updateOneReaded(letterId, developerId);
        return this.internalLetterService.find(letterId);
    }

    @Override
    public InternalLetterDO find(Long letterId) {
        return this.internalLetterService.find(letterId);
    }

    @Override
    public Integer getNoRead(Long developerId) {
        Integer count = this.internalLetterKeyService.getNoRead(developerId);
        return count;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void pushTask(Long letterId) {
        InternalLetterTask task = (InternalLetterTask)this.applicationContext.getBean(InternalLetterTask.class);
        if (Objects.equal(null, (Object)task)) {
            throw new RuntimeException("\u7ed4\u6b0f\u5534\u6dc7\u2032\u6362\u9354\u2103\u6e6d\u95b0\u5d87\u7586");
        }
        task.setLetterId(letterId);
        this.threadPoolDuibaService.submit((Runnable)task, 1);
    }
}

