/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.dao.internalletter.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.internalletter.InternalLetterKeyDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import cn.com.duiba.developer.center.common.dao.DatabaseSchema;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Repository;

@Repository
public class InternalLetterKeyDaoImpl
extends BaseDao
implements InternalLetterKeyDao {
    @PostConstruct
    public void init() {
        this.databaseSchema = DatabaseSchema.MANAGER;
    }

    @Override
    public List<InternalLetterKeyDO> findPage(PageQueryEntity param) {
        return this.selectList("findPage", param);
    }

    @Override
    public Long findPageCount(PageQueryEntity param) {
        return (Long)this.selectOne("findPageCount", param);
    }

    @Override
    public int batchDelete(Long letterId) {
        return this.update("batchDelete", letterId);
    }

    @Override
    public int deleteOne(Long letterId, Long developerId) {
        HashMap params = Maps.newHashMap();
        params.put("letterId", letterId);
        params.put("developerId", developerId);
        return this.update("deleteOne", params);
    }

    @Override
    public int batchInsert(InternalLetterDO letter, List<Long> developerIds) {
        if (Objects.equal(null, (Object)letter) || developerIds.isEmpty()) {
            return 0;
        }
        HashMap params = Maps.newHashMap();
        params.put("letterId", letter.getId());
        params.put("developerIds", developerIds);
        params.put("sender", letter.getSend());
        params.put("title", letter.getTitle());
        return this.insert("batchInsert", params);
    }

    @Override
    public int updateAllReaded(Long developerId) {
        return this.update("updateAllReaded", developerId);
    }

    @Override
    public int updateOneReaded(Long letterId, Long developerId) {
        HashMap params = Maps.newHashMap();
        params.put("letterId", letterId);
        params.put("developerId", developerId);
        return this.update("updateOneReaded", params);
    }

    @Override
    public int findNoReadCount(Long developerId) {
        return (Integer)this.selectOne("findNoReadCount", developerId);
    }
}

