package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppOtherDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppExtraDO;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.biz.service.credits.AppOtherService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.AppIdGenerator;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwicthTool;
import cn.com.duiba.service.exception.BusinessException;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class AppBoImpl implements AppBo {
    @Autowired
    private AppService appService;
    @Autowired
    private AppExtraService appExtraService;
    @Autowired
    private AppBudgetService appBudgetService;

    //private AppUrlS
    @Autowired
    private BizEventBus eventBus;

    @Override
    public Long createApp(CreateAppQueryParams params) throws BusinessException {

        Integer appCount = appService.findAppCountByDevId(params.getDeveloperId());
        if(appCount>10) throw new BusinessException("创建的应用不能超过10个");

        AppDO app=new AppDO(true);
        app.setName(params.getName());
        app.setCreditsRate(params.getCreditsRate());

        app.setAppKey(AppIdGenerator.generate());
        String appSecretCode = AppIdGenerator.generate();
        app.setAppSecretCode(SecureTool.encryptAppSecret(appSecretCode));

        app.setDeveloperId(params.getDeveloperId());
        app.setBudget(null);
        app.setBudgetRemain(null);
        app.setDayBudget(null);
        app.setDayBudgetRemain(null);
        app.setUnitName(params.getUnitName());

        List<String> categoryList = params.getCategory();
        app.setCategory1(categoryList.get(0));
        if(categoryList.size()==2){
            app.setCategory2(categoryList.get(1));
        }

        appService.insert(app);

        SwicthTool tool = SwicthTool.getSwicthTool(app.getId(),app.getAppSwitch());
        tool.setSwicthByBoundType(AppSimpleDto.SwitchCloseClientAlarm,true);
        tool.setSwicthByBoundType(AppSimpleDto.SwitchShowcasePlace1,true);
        tool.setSwicthByBoundType(AppSimpleDto.SwitchShowcasePlace2,true);
        tool.setSwicthByBoundType(AppSimpleDto.SwitchShowcasePlace3,true);

        appService.updateSwitch(tool);

        //改为事件监听
        //dhomeModuleManager.CreateAppLayoutDO(app);
        AppCreateEvent event = new AppCreateEvent(app);
        eventBus.post(event);

        return app.getId();
    }

    /**
     * from AappManageCtrl.updateAppConfig in manager,
     * @param appId
     * @param entranceDesc
     * @param callLoginProgram
     * @param appType
     * @param useloginCode
     * @param freeItemVip
     */
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void updateAppConfig(Long appId,String entranceDesc, String callLoginProgram,String appType, String useloginCode,String freeItemVip,String exchangeCreditsType){
        AppExtraDO appExtraDO = appExtraService.findByAppId(appId);
        if(null == appExtraDO) {
            appExtraDO = new AppExtraDO();
            appExtraDO.setAppId(appId);
            appExtraDO.setEntranceDesc(entranceDesc);
            appExtraDO.setCallLoginProgram(callLoginProgram);
            appExtraService.insertAppConfig(appExtraDO);
        } else {
            appExtraService.updateAppConfig(appId, entranceDesc, callLoginProgram);
        }
        AppSimpleDto app = appService.findForUpdate(appId);
        SwicthTool tool = SwicthTool.getSwicthTool(app.getId(),app.getAppSwitch());

        tool.setSwicthByBoundType(AppSimpleDto.SwitchCloseCreditsType,"on".equals(appType));
        tool.setSwicthByBoundType(AppSimpleDto.SwitchUseLoginCode,"on".equals(useloginCode));
        tool.setSwicthByBoundType(AppSimpleDto.SwitchFreeItemVip,"on".equals(freeItemVip));
        tool.setSwicthByBoundType(AppSimpleDto.SwitchExchangeCreditsType,"on".equals(exchangeCreditsType));

        appService.updateSwitch(tool);
    }

    @Override
    public AppSimpleDto getSimpleApp(Long id) {
        return appService.getObject(id);
    }



}
