package cn.com.duiba.developer.center.biz.bo.impl;

import java.util.*;

import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.AppLayoutBo;
import cn.com.duiba.developer.center.biz.dao.statistics.OdpsAppLayoutStatDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutDO;
import cn.com.duiba.developer.center.biz.dataobject.statistics.AppLayoutCountDo;
import cn.com.duiba.developer.center.biz.service.credits.AppLayoutBrickService;
import cn.com.duiba.developer.center.biz.service.credits.AppLayoutService;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.DateUtil;
import cn.com.duiba.wolf.utils.BeanUtils;

import javax.annotation.PostConstruct;

/**
 * Created by liuyao on 16/7/28.
 */
@Service
public class AppLayoutBoImpl implements AppLayoutBo {
    @Autowired
    private AppLayoutBrickService appLayoutBrickService;
    @Autowired
    private AppLayoutService appLayoutService;
    @Autowired
    private OdpsAppLayoutStatDao odpsAppLayoutStatDao;
    @Autowired
    private BizEventBus eventBus;

    @Autowired
    private AppGroupFactory factory;

    @Value("${dcm.theme.defaultId}")
    private String defaultThemeId;

    private Ordering<AppLayoutBrickDO> ordering = Ordering.natural().onResultOf(new Function<AppLayoutBrickDO,Integer>(){
        @Override
        public Integer apply(AppLayoutBrickDO arg0) {
            return arg0.getPayload();
        }
    });

    @PostConstruct
    public void init(){
        eventBus.register(this);
        factory.registFactoryBean(this);
    }

    @Override
    public PaginationVO<AppLayoutBrickDto> getSystemThemeLayoutPage(PageQueryEntity params) {
        PaginationVO<AppLayoutBrickDto> page = new PaginationVO<AppLayoutBrickDto>();

        List<AppLayoutBrickDO> list = appLayoutBrickService.getSystemThemeLayoutPageList(params);
        list = ordering.sortedCopy(list);

        AppLayoutTransform transformTool = new AppLayoutTransform(Optional.of(list));
        transformTool.setNeedSetAppCount(true);

        Integer count = appLayoutBrickService.getSystemThemeLayoutPageCount(params);
        page.setRows(transformTool.transform());

        page.setTotalCount(count.longValue());

        return page;
    }

    @Override
    public PaginationVO<AppLayoutBrickDto> getCustomThemeLayoutPage(PageQueryEntity params) {
        PaginationVO<AppLayoutBrickDto> page = new PaginationVO<AppLayoutBrickDto>();
        List<AppLayoutBrickDO> list = appLayoutBrickService.getCustomThemeLayoutList(params);
        list = ordering.sortedCopy(list);

        AppLayoutTransform transformTool = new AppLayoutTransform(Optional.of(list));

        Integer count = appLayoutBrickService.getCustomThemeLayoutCount(params);
        page.setRows(transformTool.transform());
        page.setTotalCount(count.longValue());
        return page;
    }

    /**
     *当app的创建时,同时创建AppLayoutDO
     */
    @Subscribe
    public void createAppListener(AppCreateEvent event) {
        AppDO app = event.getApp();

        AppLayoutDO appLayoutDO = new AppLayoutDO(true);
        appLayoutDO.setAppId(app.getId());
        JSONObject json = new JSONObject();
        json.put("0",new Long(defaultThemeId));
        appLayoutDO.setBrickIds(json.toJSONString());
        appLayoutDO.setThemeColor("#11c3bc");
        appLayoutService.insert(appLayoutDO);
    }

    @Override
    public Class<?> getObjectType() {
        return AppLayoutDto.class;
    }

    @Override
    public AppLayoutDto getObject(Long appId){
        AppLayoutDO layoutDO = appLayoutService.findCacheAppLayout(appId);
        AppLayoutBrickDO brick = appLayoutBrickService.findCacheAppLayoutBrick(layoutDO.getThemeId());
        AppLayoutDto dto = new AppLayoutDto();
        dto.setId(layoutDO.getId());
        dto.setAppId(appId);
        dto.setBrickId(brick.getId());
        dto.setBrickMd5(brick.getMd5());
        dto.setImageStyle(brick.getImageStyle());
        dto.setThemeColor(layoutDO.getThemeColor());
        return dto;
    }


    class AppLayoutTransform{
        private boolean needSetAppCount = false;
        private List<AppLayoutBrickDO> list;

        private  Map<Long,Long> idAndCount = new HashMap<Long,Long>();

        public AppLayoutTransform(Optional<List<AppLayoutBrickDO>> list){
            this.list = list.get();
        }

        private List<AppLayoutBrickDto> transform(){
            if(list.isEmpty()){
                Collections.emptyList();
            }

            List<AppLayoutBrickDto> newlist = Lists.transform(list, new Function<AppLayoutBrickDO, AppLayoutBrickDto>() {

                private Long isNewDate = new Date().getTime()-3*24*60*60*1000L;

                @Override
                public AppLayoutBrickDto apply(AppLayoutBrickDO input) {
                    AppLayoutBrickDto dto = new AppLayoutBrickDto();

                    BeanUtils.copy(input,dto);
                    if(needSetAppCount){
                        dto.setAppCount(idAndCount.get(input.getId()));
                    }
                    dto.setNew(input.getGmtCreate().getTime()>isNewDate);

                    return dto;
                }
            });
            return newlist;
        }

        public void setNeedSetAppCount(boolean needSetAppCount) {
            this.needSetAppCount = needSetAppCount;
            if(!needSetAppCount)return;

            Set<Long> idSet = Sets.newHashSet();
            for(AppLayoutBrickDO brickDO : this.list){
                idSet.add(brickDO.getId());
            }
            List<Long> ids = Lists.newArrayList(idSet);
            Collection<AppLayoutCountDo> countList = odpsAppLayoutStatDao.getLayoutCount(ids, DateUtil.getDayStr(DateUtil.daysAddOrSub(new Date(), -1)));
            for(AppLayoutCountDo brick:countList){
                this.idAndCount.put(brick.getId(), brick.getAppCount());
            }
        }
    }




}
