package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppOtherDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.DeveloperDO;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.runnble.SendSecretEmailTask;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.biz.service.credits.AppOtherService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.developer.center.common.tools.SwicthTool;
import cn.com.duiba.service.exception.BusinessException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * Created by liuyao on 16/8/11.
 */
@Service
public class AppManagerBoImpl implements AppManagerBo,ApplicationContextAware {
    private ApplicationContext ctx;
    @Autowired
    private AppService appService;
    @Autowired
    private AppOtherService appOtherService;
    @Autowired
    private DeveloperService developerService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS)
    public void appInfo(AppInfoFromParams params) throws BusinessException {
        AppSimpleDto app = appService.findForUpdate(params.getAppId());
        if(Objects.equals(null,app)){
            throw new BusinessException("提交的AppId不存在");
        }

        AppDO app4u=new AppDO(params.getAppId());
        app4u.setName(params.getAppName());
        app4u.setTitle(params.getAppTitle());
        app4u.setLogo(params.getLogo());
        app4u.setCreditsRate(params.getCreditsRate());
        app4u.setUnitName(params.getUnitName());
        app4u.setCategory1(params.getCategory1());
        app4u.setCategory2(params.getCategory2());
        app4u.setEarnCreditsUrl(params.getEarnCreditsUrl());
        appService.updata(app4u);

        SwicthTool tool = SwicthTool.getSwicthTool(params.getAppId(),app.getAppSwitch());
        tool.setSwicthByBoundType(AppSimpleDto.SwitchCreditsDecimalPoint,params.getCreditsDecimalPoint());
        tool.setSwicthByBoundType(AppSimpleDto.SwitchCloseCreditsType,params.getCreditsType());
        appService.updateSwitch(tool);

        AppUpdateEvent event = new AppUpdateEvent(params.getAppId());
        eventBus.post(event);
    }

    @Override
    public void apiConfig(AppUrlDto urlDto) throws BusinessException {
        Long appId = urlDto.getId();
        AppSimpleDto app = appService.findForUpdate(appId);
        if(Objects.equals(null,app)){
            throw new BusinessException("app不存在");
        }

        AppDO update = new AppDO(app.getId());
        update.setId(appId);
        if(app.isAppSwitch(AppSimpleDto.SwitchMallCreditsType)){
            String creditsRemainQueryUrl = StringUtils.isNotBlank(urlDto.getCreditsRemainQueryUrl())?urlDto.getCreditsRemainQueryUrl():null;
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String virtualUrl = StringUtils.isNotBlank(urlDto.getVirtualExchangeUrl())?urlDto.getVirtualExchangeUrl():null;
            update.setVirtualExchangeUrl(virtualUrl);

        }else{
            String creditsRemainQueryUrl = StringUtils.isNotBlank(urlDto.getCreditsRemainQueryUrl())?urlDto.getCreditsRemainQueryUrl():"";
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String creditsConsumeNotifyUrl = StringUtils.isNotBlank(urlDto.getCreditsConsumeNotifyUrl())?urlDto.getCreditsConsumeNotifyUrl():"";
            update.setCreditsConsumeNotifyUrl(creditsConsumeNotifyUrl);
            String creditsConsumeRequestUrl = StringUtils.isNotBlank(urlDto.getCreditsConsumeRequestUrl())?urlDto.getCreditsConsumeRequestUrl():"";
            update.setCreditsConsumeRequestUrl(creditsConsumeRequestUrl);
            String virtualUrl = StringUtils.isNotBlank(urlDto.getVirtualExchangeUrl())?urlDto.getVirtualExchangeUrl():"";
            update.setVirtualExchangeUrl(virtualUrl);
        }
        update.checkApiEnableUpdate();

        appService.updata(update);

        AppUpdateEvent event = new AppUpdateEvent(app.getId());
        eventBus.post(event);
    }

    @Override
    public void budgetConfig(AppBudgetDto appBudget) throws BusinessException {
        appBudgetService.updateForDeveloperBack(appBudget);
    }

    @Override
    public void doSendSecret(Long appId) throws BusinessException {
        AppSimpleDto app = appService.getObject(appId);
        if(Objects.equals(null,app)){
            throw new BusinessException("App不存在");
        }
        AppOtherDto other = appOtherService.getObject(appId);
        if(other.getSendSecret()){
            throw new BusinessException("此APP已经发送过密钥");
        }
        DeveloperDO dev = developerService.find(app.getDeveloperId());
        SendSecretEmailTask task = ctx.getBean(SendSecretEmailTask.class);
        task.setApp(app);
        task.setDeveloper(dev);
        threadPoolDuibaService.submit(task,ThreadPoolDuibaService.PriorityHigh);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}
