package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.InternalLetterBo;
import cn.com.duiba.developer.center.biz.runnble.InternalLetterTask;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterKeyService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class InternalLetterBoImpl implements InternalLetterBo,ApplicationContextAware {
    private static final Logger log= LoggerFactory.getLogger(InternalLetterBoImpl.class);
    private ApplicationContext applicationContext;

    private Splitter spl = Splitter.on(",").trimResults().omitEmptyStrings();
    @Autowired
    private InternalLetterService internalLetterService;
    @Autowired
    private InternalLetterKeyService internalLetterKeyService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;

    private ScheduledExecutorService timeService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    private void init(){
        timeService.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                try{
                    List<Long> ids = internalLetterService.findAllCanPushIds();
                    if(ids.isEmpty()){
                        return;
                    }
                    Iterator<Long> it = ids.iterator();
                    while (it.hasNext()){
                        pushTask(it.next());
                    }
                }catch(Exception e){
                    e.printStackTrace();
                    log.error("站内信扫描失败",e);
                }
            }
        }, 1, 1, TimeUnit.MINUTES);
    }

    @Override
    @Transactional(DsConstants.DATABASE_MANAGER)
    public void submitInternalLetter(Optional<InternalLetterDO> letter) throws BusinessException {
        InternalLetterDO letterDO = letter.get();
        if(Objects.equal(InternalLetterDO.SendWay_FixedTime,letterDO.getSendWay())){
            if(Objects.equal(null,letterDO.getSendTime())){
                throw new BusinessException("定时发送必须指定发送时间");
            }else if(new Date().after(letterDO.getSendTime())){
                throw new BusinessException("定时时间必须大于当前时间");
            }
        }else{
            letterDO.setSendTime(new Date());//立即发送
        }

        if(Objects.equal(null,letterDO.getId())){
            internalLetterService.insert(letterDO);
        }else{
            InternalLetterDO old = internalLetterService.findForUpdate(letterDO.getId());
            if(Objects.equal(null,old) || old.getDeleted()){
                throw new BusinessException("该站内信已经不存在");
            }
            if(InternalLetterDO.SendStatue_Push == old.getSendStatue()){
                throw new BusinessException("已经发送的站内信不可编辑");
            }
            internalLetterService.update(letterDO);
        }
        if(Objects.equal(InternalLetterDO.SendWay_RightAway,letterDO.getSendWay())){
            log.error("立即发送站内信"+letterDO.getId());
            pushTask(letterDO.getId());
        }
    }

    @Override
    @Transactional(DsConstants.DATABASE_MANAGER)
    public void deleteInternalLette(Long letterId) throws BusinessException {
        InternalLetterDO letter = internalLetterService.findForUpdate(letterId);
        if(Objects.equal(null,letter)){
            throw new BusinessException("所要删除的站内信不存在");
        }
        internalLetterService.delete(letter);
        if(Objects.equal(InternalLetterDO.SendStatue_Push,letter.getSendStatue())){
            internalLetterKeyService.batchDelete(letter.getId());
        }
    }

    @Override
    public void deleteInternalLette(Long developerId, Long letterId) throws BusinessException {
        internalLetterKeyService.deleteOne(letterId,developerId);
    }

    @Override
    public PaginationVO<InternalLetterDO> getInternalLetterPage(InternalLetterQueryEntity param) {
        List<InternalLetterDO> list = internalLetterService.findListPage(param);
        Long count = internalLetterService.findCountPage(param);
        PaginationVO<InternalLetterDO> page = new PaginationVO<InternalLetterDO>();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public PaginationVO<InternalLetterKeyDO> getInternalLetterKeyPage(InternalLetterQueryEntity param) {
        List<InternalLetterKeyDO> list = internalLetterKeyService.findPage(param);
        Long count = internalLetterKeyService.findPageCount(param);
        PaginationVO<InternalLetterKeyDO> page = new PaginationVO<InternalLetterKeyDO>();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public int setAllReaded(Long developerId) {
        return internalLetterKeyService.updateAllReaded(developerId);
    }

    @Override
    public InternalLetterDO developerFindInternalLetter(Long developerId, Long letterId) {
        internalLetterKeyService.updateOneReaded(letterId,developerId);
        return internalLetterService.find(letterId);
    }

    @Override
    public InternalLetterDO find(Long letterId) {
        return internalLetterService.find(letterId);
    }

    @Override
    public Integer getNoRead(Long developerId) {
        Integer count = internalLetterKeyService.getNoRead(developerId);
        return count;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void pushTask(Long letterId){
        InternalLetterTask task = applicationContext.getBean(InternalLetterTask.class);
        if(Objects.equal(null,task)){
            throw new RuntimeException("站内信任务未配置");
        }
        task.setLetterId(letterId);
        threadPoolDuibaService.submit(task,ThreadPoolDuibaService.PriorityLow);
    }
}
