package cn.com.duiba.developer.center.biz.dao.app;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;

/**
 * Created by liuyao on 16/8/2.
 */
public interface AppBudgetDao {

    public void updateForDeveloperBack(AppBudgetDto budget);

    public void clearMonthBudget(Long appId);

    public void cleanDayBudget(Long appId);

    public AppBudgetDto findBudgetForUpDate(Long appId);
    /**
     * 扣除预算
     */
    public int deductBudgetDay(Long appId, Integer price);

    public int deductBudgetMonth(Long appId, Integer price);
    /**
     * 返还日预算
     */
    public void restoreDayBudget(Long appId, Integer price);
    /**
     * 返还月预算
     */
    public void restoreMonthBudget(Long appId, Integer price);

    public AppBudgetDto find(Long appId);
}
