package cn.com.duiba.developer.center.biz.dao.app;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.api.domain.vo.AppDeveloperVO;
import cn.com.duiba.developer.center.api.domain.vo.AppManageVO;
import com.google.common.base.Optional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/7/15.
 */
public interface AppDao {

    public List<AppSimpleDto> findByIds(List<Long> ids);

    public List<AppSimpleDto> findAll();

    public AppSimpleDto find(Long id);

    public void insert(AppDO app);

    public void update(AppDO app);

    public List<Long> findAllEnable();

    public AppSimpleDto findForUpdate(Long id);

    public int updateSwitch(Long id, Integer appSwitch);

    public List<AppSimpleDto> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds);

    public AppSimpleDto findByAppKey(String appKey);

    public List<AppSimpleDto> findAllByDeveloper(Long developerId);

    public List<AppSimpleDto> findAppNameByNameLike(String appName);

    /**
     * 自动推荐的兑换项 推荐的app数量
     * @param itemId
     * @return
     */
    public Integer countItemAutoRecommandApp(Long itemId);
    /**
     * 获取某兑换项自动推荐的app列表
     * @param itemId
     * @return
     */
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId);

    public List<AppSimpleDto> findAllByDeveloperIds(List<Long> developerIds);

    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap);

    public Integer findAppListCount(Map<String, Object> queryMap);
    /**
     * 找到第一个创建的App
     * @param developerId
     * @return
     */
    public AppSimpleDto findFristAppByDeveloperId(Long developerId);

    public List<AppSimpleDto> findByAppIds(List<Long> appIds);
    /**
     * 根据appId列表查询多条APP+开发者信息
     * @param appIdList
     * @return
     */
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList);
    /**
     * 查询所有app
     * @param start
     * @param pageSize
     * @return
     */
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize);

    public Map<String, Object> selectOneAppDeveloper(Long appId);

    public List<Long> selectAppIdByName(String appName);

    public List<Long> selectAppIdByEmail(String email);

    public List<Long> selectAppIdByEmailAndName(String email, String appName);

    public Integer countApp();

    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList);

    public Integer findAppCountByDevId(Long developerId);

    public String findAppSecretCode(Long id);

    //*****************************重构线********************************


    /**
     * 历史原因，以前的手机端都引用APP中的主题的，所以在更新appLayout中的主题色时，APP中的也同步修改
     * 不过在后续的开发中，应该尽可能的使用appLayout中的themeColor
     * @param app
     * @param color
     */
    @Deprecated
    public int updateAppColor(Optional<AppDO> app, Optional<String> color);


}
