package cn.com.duiba.developer.center.biz.dao.app.impl;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.biz.dao.app.AppBudgetDao;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import org.springframework.stereotype.Repository;

/**
 * Created by liuyao on 16/8/2.
 */
@Repository
public class AppBudgetDaoImpl extends BaseDao implements AppBudgetDao {

    @Override
    public void updateForDeveloperBack(AppBudgetDto appBudget) {
        update("updateForDeveloperBack", appBudget);
    }

    @Override
    public void clearMonthBudget(Long appId) {
        update("clearMonthBudget",appId);
    }

    @Override
    public void cleanDayBudget(Long appId) {
        update("cleanDayBudget",appId);
    }

    @Override
    public AppBudgetDto findBudgetForUpDate(Long appId){
        return selectOne("findBudgetForUpDate",appId);
    }

    @Override
    public int deductBudgetDay(Long appId, Integer price) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId",appId);
        map.put("price",price);
        int ret = update("deductBudgetDay",map);
        return ret;
    }

    @Override
    public int deductBudgetMonth(Long appId, Integer price) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId",appId);
        map.put("price",price);
        int ret = update("deductBudgetMonth",map);
        return ret;
    }

    @Override
    public void restoreDayBudget(Long appId, Integer price) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId",appId);
        map.put("price",price);
        update("restoreDayBudget",map);
    }

    @Override
    public void restoreMonthBudget(Long appId, Integer price) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("appId",appId);
        map.put("price",price);
        update("restoreMonthBudget",map);
    }

    @Override
    public AppBudgetDto find(Long appId) {
        return selectOne("find",appId);
    }
}
